package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Percentage;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.ProcmonProcessAttributesState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Set<String> _args;
    private Counter64 _cpuUsageSystem;
    private Counter64 _cpuUsageUser;
    private Percentage _cpuUtilization;
    private Uint64 _memoryUsage;
    private Percentage _memoryUtilization;
    private String _name;
    private Uint64 _pid;
    private Timeticks64 _startTime;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link ProcmonProcessAttributesState}.
     *
     * @param arg ProcmonProcessAttributesState from which the builder should be initialized
     */
    public StateBuilder(ProcmonProcessAttributesState arg) {
        this._pid = arg.getPid();
        this._name = arg.getName();
        this._args = arg.getArgs();
        this._startTime = arg.getStartTime();
        this._cpuUsageUser = arg.getCpuUsageUser();
        this._cpuUsageSystem = arg.getCpuUsageSystem();
        this._cpuUtilization = arg.getCpuUtilization();
        this._memoryUsage = arg.getMemoryUsage();
        this._memoryUtilization = arg.getMemoryUtilization();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._args = base.getArgs();
        this._cpuUsageSystem = base.getCpuUsageSystem();
        this._cpuUsageUser = base.getCpuUsageUser();
        this._cpuUtilization = base.getCpuUtilization();
        this._memoryUsage = base.getMemoryUsage();
        this._memoryUtilization = base.getMemoryUtilization();
        this._name = base.getName();
        this._pid = base.getPid();
        this._startTime = base.getStartTime();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link ProcmonProcessAttributesState}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ProcmonProcessAttributesState) {
            this._pid = ((ProcmonProcessAttributesState)arg).getPid();
            this._name = ((ProcmonProcessAttributesState)arg).getName();
            this._args = ((ProcmonProcessAttributesState)arg).getArgs();
            this._startTime = ((ProcmonProcessAttributesState)arg).getStartTime();
            this._cpuUsageUser = ((ProcmonProcessAttributesState)arg).getCpuUsageUser();
            this._cpuUsageSystem = ((ProcmonProcessAttributesState)arg).getCpuUsageSystem();
            this._cpuUtilization = ((ProcmonProcessAttributesState)arg).getCpuUtilization();
            this._memoryUsage = ((ProcmonProcessAttributesState)arg).getMemoryUsage();
            this._memoryUtilization = ((ProcmonProcessAttributesState)arg).getMemoryUtilization();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ProcmonProcessAttributesState]");
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getArgs()}.
     *
     * @return current value
     */
    public Set<String> getArgs() {
        return _args;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getCpuUsageSystem()}.
     *
     * @return current value
     */
    public Counter64 getCpuUsageSystem() {
        return _cpuUsageSystem;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getCpuUsageUser()}.
     *
     * @return current value
     */
    public Counter64 getCpuUsageUser() {
        return _cpuUsageUser;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getCpuUtilization()}.
     *
     * @return current value
     */
    public Percentage getCpuUtilization() {
        return _cpuUtilization;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMemoryUsage()}.
     *
     * @return current value
     */
    public Uint64 getMemoryUsage() {
        return _memoryUsage;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMemoryUtilization()}.
     *
     * @return current value
     */
    public Percentage getMemoryUtilization() {
        return _memoryUtilization;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getPid()}.
     *
     * @return current value
     */
    public Uint64 getPid() {
        return _pid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getStartTime()}.
     *
     * @return current value
     */
    public Timeticks64 getStartTime() {
        return _startTime;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getArgs()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public StateBuilder setArgs(final Set<String> values) {
        this._args = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link State#getCpuUsageSystem()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setCpuUsageSystem(final Counter64 value) {
        this._cpuUsageSystem = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getCpuUsageUser()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setCpuUsageUser(final Counter64 value) {
        this._cpuUsageUser = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getCpuUtilization()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setCpuUtilization(final Percentage value) {
        this._cpuUtilization = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMemoryUsage()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMemoryUsage(final Uint64 value) {
        this._memoryUsage = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMemoryUtilization()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMemoryUtilization(final Percentage value) {
        this._memoryUtilization = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getPid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setPid(final Uint64 value) {
        this._pid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getStartTime()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setStartTime(final Timeticks64 value) {
        this._startTime = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Set<String> _args;
        private final Counter64 _cpuUsageSystem;
        private final Counter64 _cpuUsageUser;
        private final Percentage _cpuUtilization;
        private final Uint64 _memoryUsage;
        private final Percentage _memoryUtilization;
        private final String _name;
        private final Uint64 _pid;
        private final Timeticks64 _startTime;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._args = base.getArgs();
            this._cpuUsageSystem = base.getCpuUsageSystem();
            this._cpuUsageUser = base.getCpuUsageUser();
            this._cpuUtilization = base.getCpuUtilization();
            this._memoryUsage = base.getMemoryUsage();
            this._memoryUtilization = base.getMemoryUtilization();
            this._name = base.getName();
            this._pid = base.getPid();
            this._startTime = base.getStartTime();
        }
    
        @Override
        public Set<String> getArgs() {
            return _args;
        }
        
        @Override
        public Counter64 getCpuUsageSystem() {
            return _cpuUsageSystem;
        }
        
        @Override
        public Counter64 getCpuUsageUser() {
            return _cpuUsageUser;
        }
        
        @Override
        public Percentage getCpuUtilization() {
            return _cpuUtilization;
        }
        
        @Override
        public Uint64 getMemoryUsage() {
            return _memoryUsage;
        }
        
        @Override
        public Percentage getMemoryUtilization() {
            return _memoryUtilization;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Uint64 getPid() {
            return _pid;
        }
        
        @Override
        public Timeticks64 getStartTime() {
            return _startTime;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
