package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.Process;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.ProcessKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link Processes} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Processes createProcesses(int fooXyzzy, int barBaz) {
 *         return new ProcessesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Processes, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Processes
 *
 */
@Generated("mdsal-binding-generator")
public class ProcessesBuilder {

    private Map<ProcessKey, Process> _process;


    Map<Class<? extends Augmentation<Processes>>, Augmentation<Processes>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ProcessesBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Processes}.
     *
     * @param base Processes from which the builder should be initialized
     */
    public ProcessesBuilder(Processes base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._process = base.getProcess();
    }


    /**
     * Return current value associated with the property corresponding to {@link Processes#getProcess()}.
     *
     * @return current value
     */
    public Map<ProcessKey, Process> getProcess() {
        return _process;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Processes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Processes#getProcess()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ProcessesBuilder setProcess(final Map<ProcessKey, Process> values) {
        this._process = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ProcessesBuilder addAugmentation(Augmentation<Processes> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ProcessesBuilder removeAugmentation(Class<? extends Augmentation<Processes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Processes} instance.
     *
     * @return A new {@link Processes} instance.
     */
    public @NonNull Processes build() {
        return new ProcessesImpl(this);
    }

    private static final class ProcessesImpl
        extends AbstractAugmentable<Processes>
        implements Processes {
    
        private final Map<ProcessKey, Process> _process;
    
        ProcessesImpl(ProcessesBuilder base) {
            super(base.augmentation);
            this._process = CodeHelpers.emptyToNull(base.getProcess());
        }
    
        @Override
        public Map<ProcessKey, Process> getProcess() {
            return _process;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Processes.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Processes.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Processes.bindingToString(this);
        }
    }
}
