package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformAnchorsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentPropertiesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformSubcomponentRefTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Backplane;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Chassis;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Cpu;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Fabric;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Fan;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.IntegratedCircuit;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Port;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.PowerSupply;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.SoftwareModule;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Storage;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.properties.top.Properties;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.top.components.component.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.Subcomponents;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Component} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Component createComponent(int fooXyzzy, int barBaz) {
 *         return new ComponentBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Component, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Component
 *
 */
@Generated("mdsal-binding-generator")
public class ComponentBuilder {

    private Backplane _backplane;
    private Chassis _chassis;
    private Config _config;
    private Cpu _cpu;
    private Fabric _fabric;
    private Fan _fan;
    private IntegratedCircuit _integratedCircuit;
    private String _name;
    private Port _port;
    private PowerSupply _powerSupply;
    private Properties _properties;
    private SoftwareModule _softwareModule;
    private State _state;
    private Storage _storage;
    private Subcomponents _subcomponents;
    private ComponentKey key;


    Map<Class<? extends Augmentation<Component>>, Augmentation<Component>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ComponentBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link PlatformComponentPropertiesTop}.
     *
     * @param arg PlatformComponentPropertiesTop from which the builder should be initialized
     */
    public ComponentBuilder(PlatformComponentPropertiesTop arg) {
        this._properties = arg.getProperties();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link PlatformSubcomponentRefTop}.
     *
     * @param arg PlatformSubcomponentRefTop from which the builder should be initialized
     */
    public ComponentBuilder(PlatformSubcomponentRefTop arg) {
        this._subcomponents = arg.getSubcomponents();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link PlatformAnchorsTop}.
     *
     * @param arg PlatformAnchorsTop from which the builder should be initialized
     */
    public ComponentBuilder(PlatformAnchorsTop arg) {
        this._chassis = arg.getChassis();
        this._port = arg.getPort();
        this._powerSupply = arg.getPowerSupply();
        this._fan = arg.getFan();
        this._fabric = arg.getFabric();
        this._storage = arg.getStorage();
        this._cpu = arg.getCpu();
        this._integratedCircuit = arg.getIntegratedCircuit();
        this._backplane = arg.getBackplane();
        this._softwareModule = arg.getSoftwareModule();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Component}.
     *
     * @param base Component from which the builder should be initialized
     */
    public ComponentBuilder(Component base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._backplane = base.getBackplane();
        this._chassis = base.getChassis();
        this._config = base.getConfig();
        this._cpu = base.getCpu();
        this._fabric = base.getFabric();
        this._fan = base.getFan();
        this._integratedCircuit = base.getIntegratedCircuit();
        this._port = base.getPort();
        this._powerSupply = base.getPowerSupply();
        this._properties = base.getProperties();
        this._softwareModule = base.getSoftwareModule();
        this._state = base.getState();
        this._storage = base.getStorage();
        this._subcomponents = base.getSubcomponents();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PlatformSubcomponentRefTop}</li>
     *   <li>{@link PlatformAnchorsTop}</li>
     *   <li>{@link PlatformComponentPropertiesTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PlatformSubcomponentRefTop) {
            this._subcomponents = ((PlatformSubcomponentRefTop)arg).getSubcomponents();
            isValidArg = true;
        }
        if (arg instanceof PlatformAnchorsTop) {
            this._chassis = ((PlatformAnchorsTop)arg).getChassis();
            this._port = ((PlatformAnchorsTop)arg).getPort();
            this._powerSupply = ((PlatformAnchorsTop)arg).getPowerSupply();
            this._fan = ((PlatformAnchorsTop)arg).getFan();
            this._fabric = ((PlatformAnchorsTop)arg).getFabric();
            this._storage = ((PlatformAnchorsTop)arg).getStorage();
            this._cpu = ((PlatformAnchorsTop)arg).getCpu();
            this._integratedCircuit = ((PlatformAnchorsTop)arg).getIntegratedCircuit();
            this._backplane = ((PlatformAnchorsTop)arg).getBackplane();
            this._softwareModule = ((PlatformAnchorsTop)arg).getSoftwareModule();
            isValidArg = true;
        }
        if (arg instanceof PlatformComponentPropertiesTop) {
            this._properties = ((PlatformComponentPropertiesTop)arg).getProperties();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PlatformSubcomponentRefTop, PlatformAnchorsTop, PlatformComponentPropertiesTop]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Component#key()}.
     *
     * @return current value
     */
    public ComponentKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getBackplane()}.
     *
     * @return current value
     */
    public Backplane getBackplane() {
        return _backplane;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getChassis()}.
     *
     * @return current value
     */
    public Chassis getChassis() {
        return _chassis;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getCpu()}.
     *
     * @return current value
     */
    public Cpu getCpu() {
        return _cpu;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getFabric()}.
     *
     * @return current value
     */
    public Fabric getFabric() {
        return _fabric;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getFan()}.
     *
     * @return current value
     */
    public Fan getFan() {
        return _fan;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getIntegratedCircuit()}.
     *
     * @return current value
     */
    public IntegratedCircuit getIntegratedCircuit() {
        return _integratedCircuit;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getPort()}.
     *
     * @return current value
     */
    public Port getPort() {
        return _port;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getPowerSupply()}.
     *
     * @return current value
     */
    public PowerSupply getPowerSupply() {
        return _powerSupply;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getProperties()}.
     *
     * @return current value
     */
    public Properties getProperties() {
        return _properties;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getSoftwareModule()}.
     *
     * @return current value
     */
    public SoftwareModule getSoftwareModule() {
        return _softwareModule;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getStorage()}.
     *
     * @return current value
     */
    public Storage getStorage() {
        return _storage;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Component#getSubcomponents()}.
     *
     * @return current value
     */
    public Subcomponents getSubcomponents() {
        return _subcomponents;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Component>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ComponentBuilder withKey(final ComponentKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getBackplane()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setBackplane(final Backplane value) {
        this._backplane = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getChassis()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setChassis(final Chassis value) {
        this._chassis = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getCpu()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setCpu(final Cpu value) {
        this._cpu = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getFabric()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setFabric(final Fabric value) {
        this._fabric = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getFan()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setFan(final Fan value) {
        this._fan = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getIntegratedCircuit()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setIntegratedCircuit(final IntegratedCircuit value) {
        this._integratedCircuit = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getPort()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setPort(final Port value) {
        this._port = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getPowerSupply()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setPowerSupply(final PowerSupply value) {
        this._powerSupply = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getProperties()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setProperties(final Properties value) {
        this._properties = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getSoftwareModule()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setSoftwareModule(final SoftwareModule value) {
        this._softwareModule = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getStorage()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setStorage(final Storage value) {
        this._storage = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Component#getSubcomponents()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ComponentBuilder setSubcomponents(final Subcomponents value) {
        this._subcomponents = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ComponentBuilder addAugmentation(Augmentation<Component> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ComponentBuilder removeAugmentation(Class<? extends Augmentation<Component>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Component} instance.
     *
     * @return A new {@link Component} instance.
     */
    public @NonNull Component build() {
        return new ComponentImpl(this);
    }

    private static final class ComponentImpl
        extends AbstractAugmentable<Component>
        implements Component {
    
        private final Backplane _backplane;
        private final Chassis _chassis;
        private final Config _config;
        private final Cpu _cpu;
        private final Fabric _fabric;
        private final Fan _fan;
        private final IntegratedCircuit _integratedCircuit;
        private final String _name;
        private final Port _port;
        private final PowerSupply _powerSupply;
        private final Properties _properties;
        private final SoftwareModule _softwareModule;
        private final State _state;
        private final Storage _storage;
        private final Subcomponents _subcomponents;
        private final ComponentKey key;
    
        ComponentImpl(ComponentBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ComponentKey(base.getName());
            }
            this._name = key.getName();
            this._backplane = base.getBackplane();
            this._chassis = base.getChassis();
            this._config = base.getConfig();
            this._cpu = base.getCpu();
            this._fabric = base.getFabric();
            this._fan = base.getFan();
            this._integratedCircuit = base.getIntegratedCircuit();
            this._port = base.getPort();
            this._powerSupply = base.getPowerSupply();
            this._properties = base.getProperties();
            this._softwareModule = base.getSoftwareModule();
            this._state = base.getState();
            this._storage = base.getStorage();
            this._subcomponents = base.getSubcomponents();
        }
    
        @Override
        public ComponentKey key() {
            return key;
        }
        
        @Override
        public Backplane getBackplane() {
            return _backplane;
        }
        
        @Override
        public Chassis getChassis() {
            return _chassis;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public Cpu getCpu() {
            return _cpu;
        }
        
        @Override
        public Fabric getFabric() {
            return _fabric;
        }
        
        @Override
        public Fan getFan() {
            return _fan;
        }
        
        @Override
        public IntegratedCircuit getIntegratedCircuit() {
            return _integratedCircuit;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Port getPort() {
            return _port;
        }
        
        @Override
        public PowerSupply getPowerSupply() {
            return _powerSupply;
        }
        
        @Override
        public Properties getProperties() {
            return _properties;
        }
        
        @Override
        public SoftwareModule getSoftwareModule() {
            return _softwareModule;
        }
        
        @Override
        public State getState() {
            return _state;
        }
        
        @Override
        public Storage getStorage() {
            return _storage;
        }
        
        @Override
        public Subcomponents getSubcomponents() {
            return _subcomponents;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Component.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Component.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Component.bindingToString(this);
        }
    }
}
