package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.temp.state;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121.OPENCONFIGALARMSEVERITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.MinMaxTime;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatInterval;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatIntervalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentTempAlarmState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118.AvgMinMaxInstantStatsPrecision1Celsius;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link Temperature} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Temperature createTemperature(int fooXyzzy, int barBaz) {
 *         return new TemperatureBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Temperature, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Temperature
 *
 */
@Generated("mdsal-binding-generator")
public class TemperatureBuilder {

    private Class<? extends OPENCONFIGALARMSEVERITY> _alarmSeverity;
    private Boolean _alarmStatus;
    private Uint32 _alarmThreshold;
    private Decimal64 _avg;
    private Decimal64 _instant;
    private StatInterval _interval;
    private Decimal64 _max;
    private Timeticks64 _maxTime;
    private Decimal64 _min;
    private Timeticks64 _minTime;


    Map<Class<? extends Augmentation<Temperature>>, Augmentation<Temperature>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public TemperatureBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link AvgMinMaxInstantStatsPrecision1Celsius}.
     *
     * @param arg AvgMinMaxInstantStatsPrecision1Celsius from which the builder should be initialized
     */
    public TemperatureBuilder(AvgMinMaxInstantStatsPrecision1Celsius arg) {
        this._instant = arg.getInstant();
        this._avg = arg.getAvg();
        this._min = arg.getMin();
        this._max = arg.getMax();
        this._interval = arg.getInterval();
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }
    
    /**
     * Construct a new builder initialized from specified {@link StatIntervalState}.
     *
     * @param arg StatIntervalState from which the builder should be initialized
     */
    public TemperatureBuilder(StatIntervalState arg) {
        this._interval = arg.getInterval();
    }
    
    /**
     * Construct a new builder initialized from specified {@link MinMaxTime}.
     *
     * @param arg MinMaxTime from which the builder should be initialized
     */
    public TemperatureBuilder(MinMaxTime arg) {
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link PlatformComponentTempAlarmState}.
     *
     * @param arg PlatformComponentTempAlarmState from which the builder should be initialized
     */
    public TemperatureBuilder(PlatformComponentTempAlarmState arg) {
        this._alarmStatus = arg.getAlarmStatus();
        this._alarmThreshold = arg.getAlarmThreshold();
        this._alarmSeverity = arg.getAlarmSeverity();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Temperature}.
     *
     * @param base Temperature from which the builder should be initialized
     */
    public TemperatureBuilder(Temperature base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._alarmSeverity = base.getAlarmSeverity();
        this._alarmStatus = base.getAlarmStatus();
        this._alarmThreshold = base.getAlarmThreshold();
        this._avg = base.getAvg();
        this._instant = base.getInstant();
        this._interval = base.getInterval();
        this._max = base.getMax();
        this._maxTime = base.getMaxTime();
        this._min = base.getMin();
        this._minTime = base.getMinTime();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link PlatformComponentTempAlarmState}</li>
     *   <li>{@link AvgMinMaxInstantStatsPrecision1Celsius}</li>
     *   <li>{@link StatIntervalState}</li>
     *   <li>{@link MinMaxTime}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PlatformComponentTempAlarmState) {
            this._alarmStatus = ((PlatformComponentTempAlarmState)arg).getAlarmStatus();
            this._alarmThreshold = ((PlatformComponentTempAlarmState)arg).getAlarmThreshold();
            this._alarmSeverity = ((PlatformComponentTempAlarmState)arg).getAlarmSeverity();
            isValidArg = true;
        }
        if (arg instanceof AvgMinMaxInstantStatsPrecision1Celsius) {
            this._instant = ((AvgMinMaxInstantStatsPrecision1Celsius)arg).getInstant();
            this._avg = ((AvgMinMaxInstantStatsPrecision1Celsius)arg).getAvg();
            this._min = ((AvgMinMaxInstantStatsPrecision1Celsius)arg).getMin();
            this._max = ((AvgMinMaxInstantStatsPrecision1Celsius)arg).getMax();
            isValidArg = true;
        }
        if (arg instanceof StatIntervalState) {
            this._interval = ((StatIntervalState)arg).getInterval();
            isValidArg = true;
        }
        if (arg instanceof MinMaxTime) {
            this._minTime = ((MinMaxTime)arg).getMinTime();
            this._maxTime = ((MinMaxTime)arg).getMaxTime();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[PlatformComponentTempAlarmState, AvgMinMaxInstantStatsPrecision1Celsius, StatIntervalState, MinMaxTime]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Temperature#getAlarmSeverity()}.
     *
     * @return current value
     */
    public Class<? extends OPENCONFIGALARMSEVERITY> getAlarmSeverity() {
        return _alarmSeverity;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Temperature#getAlarmStatus()}.
     *
     * @return current value
     */
    public Boolean getAlarmStatus() {
        return _alarmStatus;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Temperature#getAlarmThreshold()}.
     *
     * @return current value
     */
    public Uint32 getAlarmThreshold() {
        return _alarmThreshold;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Temperature#getAvg()}.
     *
     * @return current value
     */
    public Decimal64 getAvg() {
        return _avg;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Temperature#getInstant()}.
     *
     * @return current value
     */
    public Decimal64 getInstant() {
        return _instant;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Temperature#getInterval()}.
     *
     * @return current value
     */
    public StatInterval getInterval() {
        return _interval;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Temperature#getMax()}.
     *
     * @return current value
     */
    public Decimal64 getMax() {
        return _max;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Temperature#getMaxTime()}.
     *
     * @return current value
     */
    public Timeticks64 getMaxTime() {
        return _maxTime;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Temperature#getMin()}.
     *
     * @return current value
     */
    public Decimal64 getMin() {
        return _min;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Temperature#getMinTime()}.
     *
     * @return current value
     */
    public Timeticks64 getMinTime() {
        return _minTime;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Temperature>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Temperature#getAlarmSeverity()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setAlarmSeverity(final Class<? extends OPENCONFIGALARMSEVERITY> value) {
        this._alarmSeverity = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Temperature#getAlarmStatus()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setAlarmStatus(final Boolean value) {
        this._alarmStatus = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Temperature#getAlarmThreshold()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setAlarmThreshold(final Uint32 value) {
        this._alarmThreshold = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Temperature#getAvg()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setAvg(final Decimal64 value) {
        this._avg = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Temperature#getInstant()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setInstant(final Decimal64 value) {
        this._instant = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Temperature#getInterval()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setInterval(final StatInterval value) {
        this._interval = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Temperature#getMax()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setMax(final Decimal64 value) {
        this._max = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Temperature#getMaxTime()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setMaxTime(final Timeticks64 value) {
        this._maxTime = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Temperature#getMin()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setMin(final Decimal64 value) {
        this._min = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Temperature#getMinTime()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TemperatureBuilder setMinTime(final Timeticks64 value) {
        this._minTime = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TemperatureBuilder addAugmentation(Augmentation<Temperature> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TemperatureBuilder removeAugmentation(Class<? extends Augmentation<Temperature>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Temperature} instance.
     *
     * @return A new {@link Temperature} instance.
     */
    public @NonNull Temperature build() {
        return new TemperatureImpl(this);
    }

    private static final class TemperatureImpl
        extends AbstractAugmentable<Temperature>
        implements Temperature {
    
        private final Class<? extends OPENCONFIGALARMSEVERITY> _alarmSeverity;
        private final Boolean _alarmStatus;
        private final Uint32 _alarmThreshold;
        private final Decimal64 _avg;
        private final Decimal64 _instant;
        private final StatInterval _interval;
        private final Decimal64 _max;
        private final Timeticks64 _maxTime;
        private final Decimal64 _min;
        private final Timeticks64 _minTime;
    
        TemperatureImpl(TemperatureBuilder base) {
            super(base.augmentation);
            this._alarmSeverity = base.getAlarmSeverity();
            this._alarmStatus = base.getAlarmStatus();
            this._alarmThreshold = base.getAlarmThreshold();
            this._avg = base.getAvg();
            this._instant = base.getInstant();
            this._interval = base.getInterval();
            this._max = base.getMax();
            this._maxTime = base.getMaxTime();
            this._min = base.getMin();
            this._minTime = base.getMinTime();
        }
    
        @Override
        public Class<? extends OPENCONFIGALARMSEVERITY> getAlarmSeverity() {
            return _alarmSeverity;
        }
        
        @Override
        public Boolean getAlarmStatus() {
            return _alarmStatus;
        }
        
        @Override
        public Uint32 getAlarmThreshold() {
            return _alarmThreshold;
        }
        
        @Override
        public Decimal64 getAvg() {
            return _avg;
        }
        
        @Override
        public Decimal64 getInstant() {
            return _instant;
        }
        
        @Override
        public StatInterval getInterval() {
            return _interval;
        }
        
        @Override
        public Decimal64 getMax() {
            return _max;
        }
        
        @Override
        public Timeticks64 getMaxTime() {
            return _maxTime;
        }
        
        @Override
        public Decimal64 getMin() {
            return _min;
        }
        
        @Override
        public Timeticks64 getMinTime() {
            return _minTime;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Temperature.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Temperature.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Temperature.bindingToString(this);
        }
    }
}
