package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.Memory;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Per-component memory statistics
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-component-memory-state {
 *   container memory {
 *     leaf available {
 *       type uint64;
 *       units bytes;
 *     }
 *     leaf utilized {
 *       type uint64;
 *       units bytes;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformComponentMemoryState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("platform-component-memory-state");

    @Override
    Class<? extends PlatformComponentMemoryState> implementedInterface();
    
    /**
     * Return memory, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         For components that have associated memory, these values report information
     *         about available and utilized memory.
     *     </code>
     * </pre>
     *
     * @return {@code Memory} memory, or {@code null} if it is not present.
     *
     */
    Memory getMemory();

}

