package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.Connections;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers.controller.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers.controller.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Controller} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Controller createController(int fooXyzzy, int barBaz) {
 *         return new ControllerBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Controller, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Controller
 *
 */
@Generated("mdsal-binding-generator")
public class ControllerBuilder {

    private Config _config;
    private Connections _connections;
    private String _name;
    private State _state;
    private ControllerKey key;


    Map<Class<? extends Augmentation<Controller>>, Augmentation<Controller>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ControllerBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link OpenflowConnectionsTop}.
     *
     * @param arg OpenflowConnectionsTop from which the builder should be initialized
     */
    public ControllerBuilder(OpenflowConnectionsTop arg) {
        this._connections = arg.getConnections();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Controller}.
     *
     * @param base Controller from which the builder should be initialized
     */
    public ControllerBuilder(Controller base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._config = base.getConfig();
        this._connections = base.getConnections();
        this._state = base.getState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link OpenflowConnectionsTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenflowConnectionsTop) {
            this._connections = ((OpenflowConnectionsTop)arg).getConnections();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[OpenflowConnectionsTop]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Controller#key()}.
     *
     * @return current value
     */
    public ControllerKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Controller#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Controller#getConnections()}.
     *
     * @return current value
     */
    public Connections getConnections() {
        return _connections;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Controller#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Controller#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Controller>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ControllerBuilder withKey(final ControllerKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Controller#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ControllerBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Controller#getConnections()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ControllerBuilder setConnections(final Connections value) {
        this._connections = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Controller#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ControllerBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Controller#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ControllerBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ControllerBuilder addAugmentation(Augmentation<Controller> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ControllerBuilder removeAugmentation(Class<? extends Augmentation<Controller>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Controller} instance.
     *
     * @return A new {@link Controller} instance.
     */
    public @NonNull Controller build() {
        return new ControllerImpl(this);
    }

    private static final class ControllerImpl
        extends AbstractAugmentable<Controller>
        implements Controller {
    
        private final Config _config;
        private final Connections _connections;
        private final String _name;
        private final State _state;
        private final ControllerKey key;
    
        ControllerImpl(ControllerBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ControllerKey(base.getName());
            }
            this._name = key.getName();
            this._config = base.getConfig();
            this._connections = base.getConnections();
            this._state = base.getState();
        }
    
        @Override
        public ControllerKey key() {
            return key;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public Connections getConnections() {
            return _connections;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Controller.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Controller.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Controller.bindingToString(this);
        }
    }
}
