package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.Connection;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.connections.ConnectionKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for list of controller connections
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * container connections {
 *   list connection {
 *     key aux-id;
 *     leaf aux-id {
 *       type leafref {
 *         path ../config/aux-id;
 *       }
 *     }
 *     container config {
 *       uses openflow-connections-config;
 *     }
 *     container state {
 *       config false;
 *       uses openflow-connections-config;
 *       uses openflow-connections-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ConnectionsBuilder}.
 * @see ConnectionsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Connections
    extends
    ChildOf<OpenflowConnectionsTop>,
    Augmentable<Connections>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("connections");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.Connections> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.Connections.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.@NonNull Connections obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getConnection());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.@NonNull Connections thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.Connections other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.Connections.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getConnection(), other.getConnection())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.@NonNull Connections obj) {
        final var helper = MoreObjects.toStringHelper("Connections");
        CodeHelpers.appendValue(helper, "connection", obj.getConnection());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return connection, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of connections to the OpenFlow controller. The Openflow switch always
     *         connects to configured Openflow controllers. Each controller can have more than
     *         one connection, called auxiliary Openflow connections.
     *     </code>
     * </pre>
     *
     * @return {@code Map<ConnectionKey, Connection>} connection, or {@code null} if it is not present.
     *
     */
    @Nullable Map<ConnectionKey, Connection> getConnection();
    
    /**
     * Return connection, or an empty list if it is not present.
     *
     * @return {@code Map<ConnectionKey, Connection>} connection, or an empty list if it is not present.
     *
     */
    default @NonNull Map<ConnectionKey, Connection> nonnullConnection() {
        return CodeHelpers.nonnull(getConnection());
    }

}

