package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines configuration and operational state data for Openflow.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * module openconfig-openflow {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/openflow";
 *   prefix openflow;
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   import openconfig-inet-types {
 *     prefix oc-inet;
 *   }
 *   import openconfig-interfaces {
 *     prefix oc-if;
 *   }
 *   import openconfig-openflow-types {
 *     prefix of-types;
 *   }
 *   import openconfig-system {
 *     prefix oc-sys;
 *   }
 *   oc-ext:openconfig-version 0.1.2;
 *   revision 2018-11-21 {
 *   }
 *   revision 2017-08-24 {
 *   }
 *   revision 2017-06-01 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   grouping openflow-controller-config {
 *     leaf name {
 *       type string;
 *     }
 *   }
 *   grouping openflow-controller-state {
 *   }
 *   grouping openflow-controllers-top {
 *     container controllers {
 *       list controller {
 *         key name;
 *         leaf name {
 *           type leafref {
 *             path ../config/name;
 *           }
 *         }
 *         container config {
 *           uses openflow-controller-config;
 *         }
 *         container state {
 *           config false;
 *           uses openflow-controller-config;
 *           uses openflow-controller-state;
 *         }
 *         uses openflow-connections-top;
 *       }
 *     }
 *   }
 *   grouping openflow-connections-config {
 *     leaf aux-id {
 *       type of-types:auxiliary-id;
 *     }
 *     leaf priority {
 *       type uint8;
 *     }
 *     leaf address {
 *       type oc-inet:ip-address;
 *     }
 *     leaf port {
 *       type oc-inet:port-number;
 *       default 6653;
 *     }
 *     leaf transport {
 *       type of-types:transport;
 *       default TCP;
 *     }
 *     leaf certificate-id {
 *       type string;
 *     }
 *     leaf source-interface {
 *       type oc-if:base-interface-ref;
 *     }
 *   }
 *   grouping openflow-connections-state {
 *     leaf connected {
 *       type boolean;
 *     }
 *   }
 *   grouping openflow-connections-top {
 *     container connections {
 *       list connection {
 *         key aux-id;
 *         leaf aux-id {
 *           type leafref {
 *             path ../config/aux-id;
 *           }
 *         }
 *         container config {
 *           uses openflow-connections-config;
 *         }
 *         container state {
 *           config false;
 *           uses openflow-connections-config;
 *           uses openflow-connections-state;
 *         }
 *       }
 *     }
 *   }
 *   grouping openflow-agent-config {
 *     leaf datapath-id {
 *       type of-types:datapath-id;
 *     }
 *     leaf failure-mode {
 *       type of-types:failure-mode;
 *     }
 *     leaf backoff-interval {
 *       type uint32;
 *       units seconds;
 *     }
 *     leaf max-backoff {
 *       type uint32;
 *       units seconds;
 *     }
 *     leaf inactivity-probe {
 *       type uint32;
 *       units seconds;
 *     }
 *   }
 *   grouping openflow-agent-state {
 *   }
 *   grouping openflow-agent-top {
 *     container agent {
 *       container config {
 *         uses openflow-agent-config;
 *       }
 *       container state {
 *         config false;
 *         uses openflow-agent-config;
 *         uses openflow-agent-state;
 *       }
 *     }
 *   }
 *   grouping openflow-top {
 *     container openflow {
 *       uses openflow-controllers-top;
 *       uses openflow-agent-top;
 *     }
 *   }
 *   augment /oc-sys:system {
 *     uses openflow-top;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigOpenflowData
    extends
    DataRoot
{





}

