package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.debug.messages.top.DebugEntries;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for enabling Syslog debug messages.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-messages</b>
 * <pre>
 * grouping debug-messages-top {
 *   container debug-entries {
 *     list debug-service {
 *       key service;
 *       leaf service {
 *         type leafref {
 *           path ../config/service;
 *         }
 *       }
 *       container config {
 *         uses debug-messages-config;
 *       }
 *       container state {
 *         config false;
 *         uses debug-messages-config;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface DebugMessagesTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("debug-messages-top");

    @Override
    Class<? extends DebugMessagesTop> implementedInterface();
    
    /**
     * Return debugEntries, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for list of debugs to enable.
     *     </code>
     * </pre>
     *
     * @return {@code DebugEntries} debugEntries, or {@code null} if it is not present.
     *
     */
    DebugEntries getDebugEntries();

}

