package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.Alarm;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for a device alarm
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarms</b>
 * <pre>
 * container state {
 *   config false;
 *   uses alarm-config;
 *   uses alarm-state;
 * }
 * </pre>
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<Alarm>,
    Augmentable<State>,
    AlarmConfig,
    AlarmState
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.@NonNull State obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getId());
        result = prime * result + Objects.hashCode(obj.getResource());
        result = prime * result + Objects.hashCode(obj.getSeverity());
        result = prime * result + Objects.hashCode(obj.getText());
        result = prime * result + Objects.hashCode(obj.getTimeCreated());
        result = prime * result + Objects.hashCode(obj.getTypeId());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.State other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.State.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getSeverity(), other.getSeverity())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTimeCreated(), other.getTimeCreated())) {
            return false;
        }
        if (!Objects.equals(thisObj.getId(), other.getId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getResource(), other.getResource())) {
            return false;
        }
        if (!Objects.equals(thisObj.getText(), other.getText())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTypeId(), other.getTypeId())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.alarm.@NonNull State obj) {
        final var helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "id", obj.getId());
        CodeHelpers.appendValue(helper, "resource", obj.getResource());
        CodeHelpers.appendValue(helper, "severity", obj.getSeverity());
        CodeHelpers.appendValue(helper, "text", obj.getText());
        CodeHelpers.appendValue(helper, "timeCreated", obj.getTimeCreated());
        CodeHelpers.appendValue(helper, "typeId", obj.getTypeId());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

