package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines operational state data related to alarms that the device is 
 * reporting. This model reuses some data items defined in the draft IETF YANG 
 * Alarm Module: https://tools.ietf.org/html/draft-vallin-netmod-alarm-module-02 
 * Portions of this code were derived from the draft IETF YANG Alarm Module. 
 * reproduce this note if possible. IETF code is subject to the following 
 * and license: Copyright (c) IETF Trust and the persons identified as authors of 
 * the code. All rights reserved. Redistribution and use in source and binary 
 * forms, with or without modification, is permitted pursuant to, and subject to 
 * the license terms contained in, the Simplified BSD License set forth in Section 
 * 4.c of the IETF Trust's Legal Provisions Relating to IETF Documents 
 * (http://trustee.ietf.org/license-info).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarms</b>
 * <pre>
 * module openconfig-alarms {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/alarms";
 *   prefix oc-alarms;
 *   import openconfig-alarm-types {
 *     prefix oc-alarm-types;
 *   }
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   import openconfig-types {
 *     prefix oc-types;
 *   }
 *   import openconfig-platform {
 *     prefix oc-platform;
 *   }
 *   oc-ext:openconfig-version 0.3.2;
 *   revision 2019-07-09 {
 *   }
 *   revision 2018-11-21 {
 *   }
 *   revision 2018-01-16 {
 *   }
 *   revision 2018-01-10 {
 *   }
 *   revision 2017-08-24 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   grouping alarm-state {
 *     leaf id {
 *       type string;
 *     }
 *     leaf resource {
 *       type string;
 *     }
 *     leaf text {
 *       type string;
 *     }
 *     leaf time-created {
 *       type oc-types:timeticks64;
 *     }
 *     leaf severity {
 *       type identityref {
 *         base OPENCONFIG_ALARM_SEVERITY;
 *       }
 *     }
 *     leaf type-id {
 *       type union {
 *         type string;
 *         type identityref {
 *           base OPENCONFIG_ALARM_TYPE_ID;
 *         }
 *       }
 *     }
 *   }
 *   grouping alarm-config {
 *   }
 *   grouping alarms-top {
 *     container alarms {
 *       config false;
 *       list alarm {
 *         key id;
 *         leaf id {
 *           type leafref {
 *             path ../state/id;
 *           }
 *         }
 *         container config {
 *           uses alarm-config;
 *         }
 *         container state {
 *           config false;
 *           uses alarm-config;
 *           uses alarm-state;
 *         }
 *       }
 *     }
 *   }
 *   augment /oc-platform:components/oc-platform:component/oc-platform:state {
 *     leaf equipment-failure {
 *       type boolean;
 *       default false;
 *     }
 *     leaf equipment-mismatch {
 *       type boolean;
 *       default false;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigAlarmsData
    extends
    DataRoot
{





}

