package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAccountingTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthenticationTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthorizationTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServergroupCommonTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.accounting.top.Accounting;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.top.Authentication;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.top.Authorization;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.ServerGroups;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.aaa.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.aaa.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Aaa} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Aaa createAaa(int fooXyzzy, int barBaz) {
 *         return new AaaBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Aaa, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Aaa
 *
 */
@Generated("mdsal-binding-generator")
public class AaaBuilder {

    private Accounting _accounting;
    private Authentication _authentication;
    private Authorization _authorization;
    private Config _config;
    private ServerGroups _serverGroups;
    private State _state;


    Map<Class<? extends Augmentation<Aaa>>, Augmentation<Aaa>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public AaaBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link AaaAuthenticationTop}.
     *
     * @param arg AaaAuthenticationTop from which the builder should be initialized
     */
    public AaaBuilder(AaaAuthenticationTop arg) {
        this._authentication = arg.getAuthentication();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link AaaAuthorizationTop}.
     *
     * @param arg AaaAuthorizationTop from which the builder should be initialized
     */
    public AaaBuilder(AaaAuthorizationTop arg) {
        this._authorization = arg.getAuthorization();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link AaaAccountingTop}.
     *
     * @param arg AaaAccountingTop from which the builder should be initialized
     */
    public AaaBuilder(AaaAccountingTop arg) {
        this._accounting = arg.getAccounting();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link AaaServergroupCommonTop}.
     *
     * @param arg AaaServergroupCommonTop from which the builder should be initialized
     */
    public AaaBuilder(AaaServergroupCommonTop arg) {
        this._serverGroups = arg.getServerGroups();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Aaa}.
     *
     * @param base Aaa from which the builder should be initialized
     */
    public AaaBuilder(Aaa base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._accounting = base.getAccounting();
        this._authentication = base.getAuthentication();
        this._authorization = base.getAuthorization();
        this._config = base.getConfig();
        this._serverGroups = base.getServerGroups();
        this._state = base.getState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link AaaServergroupCommonTop}</li>
     *   <li>{@link AaaAccountingTop}</li>
     *   <li>{@link AaaAuthorizationTop}</li>
     *   <li>{@link AaaAuthenticationTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaServergroupCommonTop) {
            this._serverGroups = ((AaaServergroupCommonTop)arg).getServerGroups();
            isValidArg = true;
        }
        if (arg instanceof AaaAccountingTop) {
            this._accounting = ((AaaAccountingTop)arg).getAccounting();
            isValidArg = true;
        }
        if (arg instanceof AaaAuthorizationTop) {
            this._authorization = ((AaaAuthorizationTop)arg).getAuthorization();
            isValidArg = true;
        }
        if (arg instanceof AaaAuthenticationTop) {
            this._authentication = ((AaaAuthenticationTop)arg).getAuthentication();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AaaServergroupCommonTop, AaaAccountingTop, AaaAuthorizationTop, AaaAuthenticationTop]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Aaa#getAccounting()}.
     *
     * @return current value
     */
    public Accounting getAccounting() {
        return _accounting;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Aaa#getAuthentication()}.
     *
     * @return current value
     */
    public Authentication getAuthentication() {
        return _authentication;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Aaa#getAuthorization()}.
     *
     * @return current value
     */
    public Authorization getAuthorization() {
        return _authorization;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Aaa#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Aaa#getServerGroups()}.
     *
     * @return current value
     */
    public ServerGroups getServerGroups() {
        return _serverGroups;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Aaa#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Aaa>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Aaa#getAccounting()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaBuilder setAccounting(final Accounting value) {
        this._accounting = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Aaa#getAuthentication()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaBuilder setAuthentication(final Authentication value) {
        this._authentication = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Aaa#getAuthorization()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaBuilder setAuthorization(final Authorization value) {
        this._authorization = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Aaa#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Aaa#getServerGroups()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaBuilder setServerGroups(final ServerGroups value) {
        this._serverGroups = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Aaa#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public AaaBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public AaaBuilder addAugmentation(Augmentation<Aaa> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public AaaBuilder removeAugmentation(Class<? extends Augmentation<Aaa>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Aaa} instance.
     *
     * @return A new {@link Aaa} instance.
     */
    public @NonNull Aaa build() {
        return new AaaImpl(this);
    }

    private static final class AaaImpl
        extends AbstractAugmentable<Aaa>
        implements Aaa {
    
        private final Accounting _accounting;
        private final Authentication _authentication;
        private final Authorization _authorization;
        private final Config _config;
        private final ServerGroups _serverGroups;
        private final State _state;
    
        AaaImpl(AaaBuilder base) {
            super(base.augmentation);
            this._accounting = base.getAccounting();
            this._authentication = base.getAuthentication();
            this._authorization = base.getAuthorization();
            this._config = base.getConfig();
            this._serverGroups = base.getServerGroups();
            this._state = base.getState();
        }
    
        @Override
        public Accounting getAccounting() {
            return _accounting;
        }
        
        @Override
        public Authentication getAuthentication() {
            return _authentication;
        }
        
        @Override
        public Authorization getAuthorization() {
            return _authorization;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public ServerGroups getServerGroups() {
            return _serverGroups;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Aaa.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Aaa.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Aaa.bindingToString(this);
        }
    }
}
