package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.event.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authorization.events.top.events.event.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAAAUTHORIZATIONEVENTTYPE;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Event} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Event createEvent(int fooXyzzy, int barBaz) {
 *         return new EventBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Event, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Event
 *
 */
@Generated("mdsal-binding-generator")
public class EventBuilder {

    private Config _config;
    private Class<? extends AAAAUTHORIZATIONEVENTTYPE> _eventType;
    private State _state;
    private EventKey key;


    Map<Class<? extends Augmentation<Event>>, Augmentation<Event>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public EventBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Event}.
     *
     * @param base Event from which the builder should be initialized
     */
    public EventBuilder(Event base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._eventType = base.getEventType();
        this._config = base.getConfig();
        this._state = base.getState();
    }


    /**
     * Return current value associated with the property corresponding to {@link Event#key()}.
     *
     * @return current value
     */
    public EventKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Event#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Event#getEventType()}.
     *
     * @return current value
     */
    public Class<? extends AAAAUTHORIZATIONEVENTTYPE> getEventType() {
        return _eventType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Event#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Event>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public EventBuilder withKey(final EventKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Event#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EventBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Event#getEventType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EventBuilder setEventType(final Class<? extends AAAAUTHORIZATIONEVENTTYPE> value) {
        this._eventType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Event#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public EventBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public EventBuilder addAugmentation(Augmentation<Event> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public EventBuilder removeAugmentation(Class<? extends Augmentation<Event>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Event} instance.
     *
     * @return A new {@link Event} instance.
     */
    public @NonNull Event build() {
        return new EventImpl(this);
    }

    private static final class EventImpl
        extends AbstractAugmentable<Event>
        implements Event {
    
        private final Config _config;
        private final Class<? extends AAAAUTHORIZATIONEVENTTYPE> _eventType;
        private final State _state;
        private final EventKey key;
    
        EventImpl(EventBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new EventKey(base.getEventType());
            }
            this._eventType = key.getEventType();
            this._config = base.getConfig();
            this._state = base.getState();
        }
    
        @Override
        public EventKey key() {
            return key;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public Class<? extends AAAAUTHORIZATIONEVENTTYPE> getEventType() {
            return _eventType;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Event.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Event.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Event.bindingToString(this);
        }
    }
}
