package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.authentication.user.top.users.user;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthenticationUserConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthenticationUserConfig.Role;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Config} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Config createConfig(int fooXyzzy, int barBaz) {
 *         return new ConfigBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Config, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Config
 *
 */
@Generated("mdsal-binding-generator")
public class ConfigBuilder {

    private String _password;
    private CryptPasswordType _passwordHashed;
    private Role _role;
    private String _sshKey;
    private String _username;


    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConfigBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link AaaAuthenticationUserConfig}.
     *
     * @param arg AaaAuthenticationUserConfig from which the builder should be initialized
     */
    public ConfigBuilder(AaaAuthenticationUserConfig arg) {
        this._username = arg.getUsername();
        this._password = arg.getPassword();
        this._passwordHashed = arg.getPasswordHashed();
        this._sshKey = arg.getSshKey();
        this._role = arg.getRole();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Config}.
     *
     * @param base Config from which the builder should be initialized
     */
    public ConfigBuilder(Config base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._password = base.getPassword();
        this._passwordHashed = base.getPasswordHashed();
        this._role = base.getRole();
        this._sshKey = base.getSshKey();
        this._username = base.getUsername();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link AaaAuthenticationUserConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaAuthenticationUserConfig) {
            this._username = ((AaaAuthenticationUserConfig)arg).getUsername();
            this._password = ((AaaAuthenticationUserConfig)arg).getPassword();
            this._passwordHashed = ((AaaAuthenticationUserConfig)arg).getPasswordHashed();
            this._sshKey = ((AaaAuthenticationUserConfig)arg).getSshKey();
            this._role = ((AaaAuthenticationUserConfig)arg).getRole();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AaaAuthenticationUserConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Config#getPassword()}.
     *
     * @return current value
     */
    public String getPassword() {
        return _password;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getPasswordHashed()}.
     *
     * @return current value
     */
    public CryptPasswordType getPasswordHashed() {
        return _passwordHashed;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getRole()}.
     *
     * @return current value
     */
    public Role getRole() {
        return _role;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getSshKey()}.
     *
     * @return current value
     */
    public String getSshKey() {
        return _sshKey;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getUsername()}.
     *
     * @return current value
     */
    public String getUsername() {
        return _username;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Config#getPassword()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setPassword(final String value) {
        this._password = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getPasswordHashed()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setPasswordHashed(final CryptPasswordType value) {
        this._passwordHashed = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getRole()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setRole(final Role value) {
        this._role = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getSshKey()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setSshKey(final String value) {
        this._sshKey = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getUsername()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setUsername(final String value) {
        this._username = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Config} instance.
     *
     * @return A new {@link Config} instance.
     */
    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
        extends AbstractAugmentable<Config>
        implements Config {
    
        private final String _password;
        private final CryptPasswordType _passwordHashed;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthenticationUserConfig.Role _role;
        private final String _sshKey;
        private final String _username;
    
        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._password = base.getPassword();
            this._passwordHashed = base.getPasswordHashed();
            this._role = base.getRole();
            this._sshKey = base.getSshKey();
            this._username = base.getUsername();
        }
    
        @Override
        public String getPassword() {
            return _password;
        }
        
        @Override
        public CryptPasswordType getPasswordHashed() {
            return _passwordHashed;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaAuthenticationUserConfig.Role getRole() {
            return _role;
        }
        
        @Override
        public String getSshKey() {
            return _sshKey;
        }
        
        @Override
        public String getUsername() {
            return _username;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Config.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Config.bindingToString(this);
        }
    }
}
