/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemTerminalCommonConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server.Config;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class ConfigBuilder {
    private Boolean _enable;
    private SystemSshServerConfig.ProtocolVersion _protocolVersion;
    private Uint16 _rateLimit;
    private Uint16 _sessionLimit;
    private Uint16 _timeout;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(SystemSshServerConfig arg) {
        this._enable = arg.getEnable();
        this._protocolVersion = arg.getProtocolVersion();
        this._timeout = arg.getTimeout();
        this._rateLimit = arg.getRateLimit();
        this._sessionLimit = arg.getSessionLimit();
    }

    public ConfigBuilder(SystemTerminalCommonConfig arg) {
        this._timeout = arg.getTimeout();
        this._rateLimit = arg.getRateLimit();
        this._sessionLimit = arg.getSessionLimit();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._enable = base.getEnable();
        this._protocolVersion = base.getProtocolVersion();
        this._rateLimit = base.getRateLimit();
        this._sessionLimit = base.getSessionLimit();
        this._timeout = base.getTimeout();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemSshServerConfig) {
            this._enable = ((SystemSshServerConfig)arg).getEnable();
            this._protocolVersion = ((SystemSshServerConfig)arg).getProtocolVersion();
            isValidArg = true;
        }
        if (arg instanceof SystemTerminalCommonConfig) {
            this._timeout = ((SystemTerminalCommonConfig)arg).getTimeout();
            this._rateLimit = ((SystemTerminalCommonConfig)arg).getRateLimit();
            this._sessionLimit = ((SystemTerminalCommonConfig)arg).getSessionLimit();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemSshServerConfig, SystemTerminalCommonConfig]");
    }

    public Boolean getEnable() {
        return this._enable;
    }

    public SystemSshServerConfig.ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    public Uint16 getRateLimit() {
        return this._rateLimit;
    }

    public Uint16 getSessionLimit() {
        return this._sessionLimit;
    }

    public Uint16 getTimeout() {
        return this._timeout;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setEnable(Boolean value) {
        this._enable = value;
        return this;
    }

    public ConfigBuilder setProtocolVersion(SystemSshServerConfig.ProtocolVersion value) {
        this._protocolVersion = value;
        return this;
    }

    public ConfigBuilder setRateLimit(Uint16 value) {
        this._rateLimit = value;
        return this;
    }

    public ConfigBuilder setSessionLimit(Uint16 value) {
        this._sessionLimit = value;
        return this;
    }

    public ConfigBuilder setTimeout(Uint16 value) {
        this._timeout = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final Boolean _enable;
        private final SystemSshServerConfig.ProtocolVersion _protocolVersion;
        private final Uint16 _rateLimit;
        private final Uint16 _sessionLimit;
        private final Uint16 _timeout;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._enable = base.getEnable();
            this._protocolVersion = base.getProtocolVersion();
            this._rateLimit = base.getRateLimit();
            this._sessionLimit = base.getSessionLimit();
            this._timeout = base.getTimeout();
        }

        @Override
        public Boolean getEnable() {
            return this._enable;
        }

        @Override
        public SystemSshServerConfig.ProtocolVersion getProtocolVersion() {
            return this._protocolVersion;
        }

        @Override
        public Uint16 getRateLimit() {
            return this._rateLimit;
        }

        @Override
        public Uint16 getSessionLimit() {
            return this._sessionLimit;
        }

        @Override
        public Uint16 getTimeout() {
            return this._timeout;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

