/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsServersTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.HostEntries;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.Servers;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.Dns;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.dns.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.dns.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DnsBuilder {
    private Config _config;
    private HostEntries _hostEntries;
    private Servers _servers;
    private State _state;
    Map<Class<? extends Augmentation<Dns>>, Augmentation<Dns>> augmentation = Map.of();

    public DnsBuilder() {
    }

    public DnsBuilder(SystemDnsServersTop arg) {
        this._servers = arg.getServers();
    }

    public DnsBuilder(SystemDnsStaticTop arg) {
        this._hostEntries = arg.getHostEntries();
    }

    public DnsBuilder(Dns base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Dns>>, Augmentation<Dns>>(aug);
        }
        this._config = base.getConfig();
        this._hostEntries = base.getHostEntries();
        this._servers = base.getServers();
        this._state = base.getState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemDnsStaticTop) {
            this._hostEntries = ((SystemDnsStaticTop)arg).getHostEntries();
            isValidArg = true;
        }
        if (arg instanceof SystemDnsServersTop) {
            this._servers = ((SystemDnsServersTop)arg).getServers();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemDnsStaticTop, SystemDnsServersTop]");
    }

    public Config getConfig() {
        return this._config;
    }

    public HostEntries getHostEntries() {
        return this._hostEntries;
    }

    public Servers getServers() {
        return this._servers;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Dns>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public DnsBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public DnsBuilder setHostEntries(HostEntries value) {
        this._hostEntries = value;
        return this;
    }

    public DnsBuilder setServers(Servers value) {
        this._servers = value;
        return this;
    }

    public DnsBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public DnsBuilder addAugmentation(Augmentation<Dns> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Dns>>, Augmentation<Dns>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public DnsBuilder removeAugmentation(Class<? extends Augmentation<Dns>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Dns build() {
        return new DnsImpl(this);
    }

    private static final class DnsImpl
    extends AbstractAugmentable<Dns>
    implements Dns {
        private final Config _config;
        private final HostEntries _hostEntries;
        private final Servers _servers;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        DnsImpl(DnsBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._hostEntries = base.getHostEntries();
            this._servers = base.getServers();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public HostEntries getHostEntries() {
            return this._hostEntries;
        }

        @Override
        public Servers getServers() {
            return this._servers;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Dns.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Dns.bindingEquals(this, obj);
        }

        public String toString() {
            return Dns.bindingToString(this);
        }
    }
}

