/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaRadiusServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaTacacsServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.top.Radius;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.Server;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.ServerKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.tacacs.server.top.Tacacs;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServerBuilder {
    private IpAddress _address;
    private Config _config;
    private Radius _radius;
    private State _state;
    private Tacacs _tacacs;
    private ServerKey key;
    Map<Class<? extends Augmentation<Server>>, Augmentation<Server>> augmentation = Map.of();

    public ServerBuilder() {
    }

    public ServerBuilder(AaaTacacsServerTop arg) {
        this._tacacs = arg.getTacacs();
    }

    public ServerBuilder(AaaRadiusServerTop arg) {
        this._radius = arg.getRadius();
    }

    public ServerBuilder(Server base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Server>>, Augmentation<Server>>(aug);
        }
        this.key = base.key();
        this._address = base.getAddress();
        this._config = base.getConfig();
        this._radius = base.getRadius();
        this._state = base.getState();
        this._tacacs = base.getTacacs();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaRadiusServerTop) {
            this._radius = ((AaaRadiusServerTop)arg).getRadius();
            isValidArg = true;
        }
        if (arg instanceof AaaTacacsServerTop) {
            this._tacacs = ((AaaTacacsServerTop)arg).getTacacs();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AaaRadiusServerTop, AaaTacacsServerTop]");
    }

    public ServerKey key() {
        return this.key;
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public Config getConfig() {
        return this._config;
    }

    public Radius getRadius() {
        return this._radius;
    }

    public State getState() {
        return this._state;
    }

    public Tacacs getTacacs() {
        return this._tacacs;
    }

    public <E$$ extends Augmentation<Server>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ServerBuilder withKey(ServerKey key) {
        this.key = key;
        return this;
    }

    public ServerBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    public ServerBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public ServerBuilder setRadius(Radius value) {
        this._radius = value;
        return this;
    }

    public ServerBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ServerBuilder setTacacs(Tacacs value) {
        this._tacacs = value;
        return this;
    }

    public ServerBuilder addAugmentation(Augmentation<Server> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Server>>, Augmentation<Server>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ServerBuilder removeAugmentation(Class<? extends Augmentation<Server>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Server build() {
        return new ServerImpl(this);
    }

    private static final class ServerImpl
    extends AbstractAugmentable<Server>
    implements Server {
        private final IpAddress _address;
        private final Config _config;
        private final Radius _radius;
        private final State _state;
        private final Tacacs _tacacs;
        private final ServerKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ServerImpl(ServerBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ServerKey(base.getAddress());
            this._address = this.key.getAddress();
            this._config = base.getConfig();
            this._radius = base.getRadius();
            this._state = base.getState();
            this._tacacs = base.getTacacs();
        }

        @Override
        public ServerKey key() {
            return this.key;
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Radius getRadius() {
            return this._radius;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Tacacs getTacacs() {
            return this._tacacs;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Server.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Server.bindingEquals(this, obj);
        }

        public String toString() {
            return Server.bindingToString(this);
        }
    }
}

