/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.outer.list;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalDoubleTaggedOuterListConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.match._double.tagged.outer.list.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private VlanId _innerVlanId;
    private Set<VlanId> _outerVlanIds;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }

    public StateBuilder(VlanLogicalDoubleTaggedOuterListConfig arg) {
        this._innerVlanId = arg.getInnerVlanId();
        this._outerVlanIds = arg.getOuterVlanIds();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._innerVlanId = base.getInnerVlanId();
        this._outerVlanIds = base.getOuterVlanIds();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanLogicalDoubleTaggedOuterListConfig) {
            this._innerVlanId = ((VlanLogicalDoubleTaggedOuterListConfig)arg).getInnerVlanId();
            this._outerVlanIds = ((VlanLogicalDoubleTaggedOuterListConfig)arg).getOuterVlanIds();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanLogicalDoubleTaggedOuterListConfig]");
    }

    public VlanId getInnerVlanId() {
        return this._innerVlanId;
    }

    public Set<VlanId> getOuterVlanIds() {
        return this._outerVlanIds;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setInnerVlanId(VlanId value) {
        this._innerVlanId = value;
        return this;
    }

    public StateBuilder setOuterVlanIds(Set<VlanId> values) {
        this._outerVlanIds = values;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final VlanId _innerVlanId;
        private final Set<VlanId> _outerVlanIds;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._innerVlanId = base.getInnerVlanId();
            this._outerVlanIds = base.getOuterVlanIds();
        }

        @Override
        public VlanId getInnerVlanId() {
            return this._innerVlanId;
        }

        @Override
        public Set<VlanId> getOuterVlanIds() {
            return this._outerVlanIds;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

