/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class Dscp
implements ScalarTypeObject<Uint8>,
Serializable {
    private static final long serialVersionUID = -6062481917342980428L;
    private final Uint8 _value;

    private static void check_valueRange(short value) {
        if (value <= 63) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..63]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public Dscp(Uint8 _value) {
        if (_value != null) {
            Dscp.check_valueRange(_value.shortValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public Dscp(Dscp source) {
        this._value = source._value;
    }

    public static Dscp getDefaultInstance(String defaultValue) {
        return new Dscp(Uint8.valueOf((String)defaultValue));
    }

    public Uint8 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Dscp)) {
            return false;
        }
        Dscp other = (Dscp)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Dscp.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

