/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.ntp.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private Counter64 _authMismatch;
    private Boolean _enableNtpAuth;
    private Boolean _enabled;
    private IpAddress _ntpSourceAddress;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }

    public StateBuilder(SystemNtpConfig arg) {
        this._enabled = arg.getEnabled();
        this._ntpSourceAddress = arg.getNtpSourceAddress();
        this._enableNtpAuth = arg.getEnableNtpAuth();
    }

    public StateBuilder(SystemNtpState arg) {
        this._authMismatch = arg.getAuthMismatch();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._authMismatch = base.getAuthMismatch();
        this._enableNtpAuth = base.getEnableNtpAuth();
        this._enabled = base.getEnabled();
        this._ntpSourceAddress = base.getNtpSourceAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemNtpState) {
            this._authMismatch = ((SystemNtpState)arg).getAuthMismatch();
            isValidArg = true;
        }
        if (arg instanceof SystemNtpConfig) {
            this._enabled = ((SystemNtpConfig)arg).getEnabled();
            this._ntpSourceAddress = ((SystemNtpConfig)arg).getNtpSourceAddress();
            this._enableNtpAuth = ((SystemNtpConfig)arg).getEnableNtpAuth();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemNtpState, SystemNtpConfig]");
    }

    public Counter64 getAuthMismatch() {
        return this._authMismatch;
    }

    public Boolean getEnableNtpAuth() {
        return this._enableNtpAuth;
    }

    public Boolean getEnabled() {
        return this._enabled;
    }

    public IpAddress getNtpSourceAddress() {
        return this._ntpSourceAddress;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAuthMismatch(Counter64 value) {
        this._authMismatch = value;
        return this;
    }

    public StateBuilder setEnableNtpAuth(Boolean value) {
        this._enableNtpAuth = value;
        return this;
    }

    public StateBuilder setEnabled(Boolean value) {
        this._enabled = value;
        return this;
    }

    public StateBuilder setNtpSourceAddress(IpAddress value) {
        this._ntpSourceAddress = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Counter64 _authMismatch;
        private final Boolean _enableNtpAuth;
        private final Boolean _enabled;
        private final IpAddress _ntpSourceAddress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._authMismatch = base.getAuthMismatch();
            this._enableNtpAuth = base.getEnableNtpAuth();
            this._enabled = base.getEnabled();
            this._ntpSourceAddress = base.getNtpSourceAddress();
        }

        @Override
        public Counter64 getAuthMismatch() {
            return this._authMismatch;
        }

        @Override
        public Boolean getEnableNtpAuth() {
            return this._enableNtpAuth;
        }

        @Override
        public Boolean getEnabled() {
            return this._enabled;
        }

        @Override
        public IpAddress getNtpSourceAddress() {
            return this._ntpSourceAddress;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

