/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

public class StateBuilder {
    private Host _address;
    private SystemNtpServerConfig.AssociationType _associationType;
    private Boolean _iburst;
    private Uint64 _offset;
    private Uint32 _pollInterval;
    private PortNumber _port;
    private Boolean _prefer;
    private Uint32 _rootDelay;
    private Uint64 _rootDispersion;
    private Uint8 _stratum;
    private Uint8 _version;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }

    public StateBuilder(SystemNtpServerConfig arg) {
        this._address = arg.getAddress();
        this._port = arg.getPort();
        this._version = arg.getVersion();
        this._associationType = arg.getAssociationType();
        this._iburst = arg.getIburst();
        this._prefer = arg.getPrefer();
    }

    public StateBuilder(SystemNtpServerState arg) {
        this._stratum = arg.getStratum();
        this._rootDelay = arg.getRootDelay();
        this._rootDispersion = arg.getRootDispersion();
        this._offset = arg.getOffset();
        this._pollInterval = arg.getPollInterval();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._address = base.getAddress();
        this._associationType = base.getAssociationType();
        this._iburst = base.getIburst();
        this._offset = base.getOffset();
        this._pollInterval = base.getPollInterval();
        this._port = base.getPort();
        this._prefer = base.getPrefer();
        this._rootDelay = base.getRootDelay();
        this._rootDispersion = base.getRootDispersion();
        this._stratum = base.getStratum();
        this._version = base.getVersion();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemNtpServerState) {
            this._stratum = ((SystemNtpServerState)arg).getStratum();
            this._rootDelay = ((SystemNtpServerState)arg).getRootDelay();
            this._rootDispersion = ((SystemNtpServerState)arg).getRootDispersion();
            this._offset = ((SystemNtpServerState)arg).getOffset();
            this._pollInterval = ((SystemNtpServerState)arg).getPollInterval();
            isValidArg = true;
        }
        if (arg instanceof SystemNtpServerConfig) {
            this._address = ((SystemNtpServerConfig)arg).getAddress();
            this._port = ((SystemNtpServerConfig)arg).getPort();
            this._version = ((SystemNtpServerConfig)arg).getVersion();
            this._associationType = ((SystemNtpServerConfig)arg).getAssociationType();
            this._iburst = ((SystemNtpServerConfig)arg).getIburst();
            this._prefer = ((SystemNtpServerConfig)arg).getPrefer();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemNtpServerState, SystemNtpServerConfig]");
    }

    public Host getAddress() {
        return this._address;
    }

    public SystemNtpServerConfig.AssociationType getAssociationType() {
        return this._associationType;
    }

    public Boolean getIburst() {
        return this._iburst;
    }

    public Uint64 getOffset() {
        return this._offset;
    }

    public Uint32 getPollInterval() {
        return this._pollInterval;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Boolean getPrefer() {
        return this._prefer;
    }

    public Uint32 getRootDelay() {
        return this._rootDelay;
    }

    public Uint64 getRootDispersion() {
        return this._rootDispersion;
    }

    public Uint8 getStratum() {
        return this._stratum;
    }

    public Uint8 getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAddress(Host value) {
        this._address = value;
        return this;
    }

    public StateBuilder setAssociationType(SystemNtpServerConfig.AssociationType value) {
        this._associationType = value;
        return this;
    }

    public StateBuilder setIburst(Boolean value) {
        this._iburst = value;
        return this;
    }

    public StateBuilder setOffset(Uint64 value) {
        this._offset = value;
        return this;
    }

    public StateBuilder setPollInterval(Uint32 value) {
        this._pollInterval = value;
        return this;
    }

    public StateBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public StateBuilder setPrefer(Boolean value) {
        this._prefer = value;
        return this;
    }

    public StateBuilder setRootDelay(Uint32 value) {
        this._rootDelay = value;
        return this;
    }

    public StateBuilder setRootDispersion(Uint64 value) {
        this._rootDispersion = value;
        return this;
    }

    public StateBuilder setStratum(Uint8 value) {
        this._stratum = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 1 && value <= 4) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..4]]", (int)value);
    }

    public StateBuilder setVersion(Uint8 value) {
        if (value != null) {
            StateBuilder.checkVersionRange(value.shortValue());
        }
        this._version = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Host _address;
        private final SystemNtpServerConfig.AssociationType _associationType;
        private final Boolean _iburst;
        private final Uint64 _offset;
        private final Uint32 _pollInterval;
        private final PortNumber _port;
        private final Boolean _prefer;
        private final Uint32 _rootDelay;
        private final Uint64 _rootDispersion;
        private final Uint8 _stratum;
        private final Uint8 _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._associationType = base.getAssociationType();
            this._iburst = base.getIburst();
            this._offset = base.getOffset();
            this._pollInterval = base.getPollInterval();
            this._port = base.getPort();
            this._prefer = base.getPrefer();
            this._rootDelay = base.getRootDelay();
            this._rootDispersion = base.getRootDispersion();
            this._stratum = base.getStratum();
            this._version = base.getVersion();
        }

        @Override
        public Host getAddress() {
            return this._address;
        }

        @Override
        public SystemNtpServerConfig.AssociationType getAssociationType() {
            return this._associationType;
        }

        @Override
        public Boolean getIburst() {
            return this._iburst;
        }

        @Override
        public Uint64 getOffset() {
            return this._offset;
        }

        @Override
        public Uint32 getPollInterval() {
            return this._pollInterval;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public Boolean getPrefer() {
            return this._prefer;
        }

        @Override
        public Uint32 getRootDelay() {
            return this._rootDelay;
        }

        @Override
        public Uint64 getRootDispersion() {
            return this._rootDispersion;
        }

        @Override
        public Uint8 getStratum() {
            return this._stratum;
        }

        @Override
        public Uint8 getVersion() {
            return this._version;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

