/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.Server;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.ServerKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ServerBuilder {
    private Host _address;
    private Config _config;
    private State _state;
    private ServerKey key;
    Map<Class<? extends Augmentation<Server>>, Augmentation<Server>> augmentation = Collections.emptyMap();

    public ServerBuilder() {
    }

    public ServerBuilder(Server base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Server>>, Augmentation<Server>>(aug);
        }
        this.key = base.key();
        this._address = base.getAddress();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public ServerKey key() {
        return this.key;
    }

    public Host getAddress() {
        return this._address;
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Server>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ServerBuilder withKey(ServerKey key) {
        this.key = key;
        return this;
    }

    public ServerBuilder setAddress(Host value) {
        this._address = value;
        return this;
    }

    public ServerBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public ServerBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ServerBuilder addAugmentation(Augmentation<Server> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Server>>, Augmentation<Server>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ServerBuilder removeAugmentation(Class<? extends Augmentation<Server>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Server build() {
        return new ServerImpl(this);
    }

    private static final class ServerImpl
    extends AbstractAugmentable<Server>
    implements Server {
        private final Host _address;
        private final Config _config;
        private final State _state;
        private final ServerKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ServerImpl(ServerBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ServerKey(base.getAddress());
            this._address = this.key.getAddress();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public ServerKey key() {
            return this.key;
        }

        @Override
        public Host getAddress() {
            return this._address;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Server.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Server.bindingEquals(this, obj);
        }

        public String toString() {
            return Server.bindingToString(this);
        }
    }
}

