/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys.NtpKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys.NtpKeyKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys.ntp.key.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys.ntp.key.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint16;

public class NtpKeyBuilder {
    private Config _config;
    private Uint16 _keyId;
    private State _state;
    private NtpKeyKey key;
    Map<Class<? extends Augmentation<NtpKey>>, Augmentation<NtpKey>> augmentation = Collections.emptyMap();

    public NtpKeyBuilder() {
    }

    public NtpKeyBuilder(NtpKey base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NtpKey>>, Augmentation<NtpKey>>(aug);
        }
        this.key = base.key();
        this._keyId = base.getKeyId();
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public NtpKeyKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public Uint16 getKeyId() {
        return this._keyId;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<NtpKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NtpKeyBuilder withKey(NtpKeyKey key) {
        this.key = key;
        return this;
    }

    public NtpKeyBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public NtpKeyBuilder setKeyId(Uint16 value) {
        this._keyId = value;
        return this;
    }

    public NtpKeyBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public NtpKeyBuilder addAugmentation(Augmentation<NtpKey> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NtpKey>>, Augmentation<NtpKey>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NtpKeyBuilder removeAugmentation(Class<? extends Augmentation<NtpKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NtpKey build() {
        return new NtpKeyImpl(this);
    }

    private static final class NtpKeyImpl
    extends AbstractAugmentable<NtpKey>
    implements NtpKey {
        private final Config _config;
        private final Uint16 _keyId;
        private final State _state;
        private final NtpKeyKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NtpKeyImpl(NtpKeyBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new NtpKeyKey(base.getKeyId());
            this._keyId = this.key.getKeyId();
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public NtpKeyKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Uint16 getKeyId() {
            return this._keyId;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NtpKey.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NtpKey.bindingEquals(this, obj);
        }

        public String toString() {
            return NtpKey.bindingToString(this);
        }
    }
}

