/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.cpu;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.HardwareInterrupt;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Idle;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Kernel;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Nice;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.SoftwareInterrupt;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Total;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.User;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Wait;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.cpu.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private HardwareInterrupt _hardwareInterrupt;
    private Idle _idle;
    private SystemCpuState.Index _index;
    private Kernel _kernel;
    private Nice _nice;
    private SoftwareInterrupt _softwareInterrupt;
    private Total _total;
    private User _user;
    private Wait _wait;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }

    public StateBuilder(SystemCpuState arg) {
        this._index = arg.getIndex();
        this._total = arg.getTotal();
        this._user = arg.getUser();
        this._kernel = arg.getKernel();
        this._nice = arg.getNice();
        this._idle = arg.getIdle();
        this._wait = arg.getWait();
        this._hardwareInterrupt = arg.getHardwareInterrupt();
        this._softwareInterrupt = arg.getSoftwareInterrupt();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._hardwareInterrupt = base.getHardwareInterrupt();
        this._idle = base.getIdle();
        this._index = base.getIndex();
        this._kernel = base.getKernel();
        this._nice = base.getNice();
        this._softwareInterrupt = base.getSoftwareInterrupt();
        this._total = base.getTotal();
        this._user = base.getUser();
        this._wait = base.getWait();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemCpuState) {
            this._index = ((SystemCpuState)arg).getIndex();
            this._total = ((SystemCpuState)arg).getTotal();
            this._user = ((SystemCpuState)arg).getUser();
            this._kernel = ((SystemCpuState)arg).getKernel();
            this._nice = ((SystemCpuState)arg).getNice();
            this._idle = ((SystemCpuState)arg).getIdle();
            this._wait = ((SystemCpuState)arg).getWait();
            this._hardwareInterrupt = ((SystemCpuState)arg).getHardwareInterrupt();
            this._softwareInterrupt = ((SystemCpuState)arg).getSoftwareInterrupt();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemCpuState]");
    }

    public HardwareInterrupt getHardwareInterrupt() {
        return this._hardwareInterrupt;
    }

    public Idle getIdle() {
        return this._idle;
    }

    public SystemCpuState.Index getIndex() {
        return this._index;
    }

    public Kernel getKernel() {
        return this._kernel;
    }

    public Nice getNice() {
        return this._nice;
    }

    public SoftwareInterrupt getSoftwareInterrupt() {
        return this._softwareInterrupt;
    }

    public Total getTotal() {
        return this._total;
    }

    public User getUser() {
        return this._user;
    }

    public Wait getWait() {
        return this._wait;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setHardwareInterrupt(HardwareInterrupt value) {
        this._hardwareInterrupt = value;
        return this;
    }

    public StateBuilder setIdle(Idle value) {
        this._idle = value;
        return this;
    }

    public StateBuilder setIndex(SystemCpuState.Index value) {
        this._index = value;
        return this;
    }

    public StateBuilder setKernel(Kernel value) {
        this._kernel = value;
        return this;
    }

    public StateBuilder setNice(Nice value) {
        this._nice = value;
        return this;
    }

    public StateBuilder setSoftwareInterrupt(SoftwareInterrupt value) {
        this._softwareInterrupt = value;
        return this;
    }

    public StateBuilder setTotal(Total value) {
        this._total = value;
        return this;
    }

    public StateBuilder setUser(User value) {
        this._user = value;
        return this;
    }

    public StateBuilder setWait(Wait value) {
        this._wait = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final HardwareInterrupt _hardwareInterrupt;
        private final Idle _idle;
        private final SystemCpuState.Index _index;
        private final Kernel _kernel;
        private final Nice _nice;
        private final SoftwareInterrupt _softwareInterrupt;
        private final Total _total;
        private final User _user;
        private final Wait _wait;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._hardwareInterrupt = base.getHardwareInterrupt();
            this._idle = base.getIdle();
            this._index = base.getIndex();
            this._kernel = base.getKernel();
            this._nice = base.getNice();
            this._softwareInterrupt = base.getSoftwareInterrupt();
            this._total = base.getTotal();
            this._user = base.getUser();
            this._wait = base.getWait();
        }

        @Override
        public HardwareInterrupt getHardwareInterrupt() {
            return this._hardwareInterrupt;
        }

        @Override
        public Idle getIdle() {
            return this._idle;
        }

        @Override
        public SystemCpuState.Index getIndex() {
            return this._index;
        }

        @Override
        public Kernel getKernel() {
            return this._kernel;
        }

        @Override
        public Nice getNice() {
            return this._nice;
        }

        @Override
        public SoftwareInterrupt getSoftwareInterrupt() {
            return this._softwareInterrupt;
        }

        @Override
        public Total getTotal() {
            return this._total;
        }

        @Override
        public User getUser() {
            return this._user;
        }

        @Override
        public Wait getWait() {
            return this._wait;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

