/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.AvgMinMaxInstantStatsPct;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.MinMaxTime;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Percentage;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatInterval;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.StatIntervalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.state.Wait;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class WaitBuilder {
    private Percentage _avg;
    private Percentage _instant;
    private StatInterval _interval;
    private Percentage _max;
    private Timeticks64 _maxTime;
    private Percentage _min;
    private Timeticks64 _minTime;
    Map<Class<? extends Augmentation<Wait>>, Augmentation<Wait>> augmentation = Collections.emptyMap();

    public WaitBuilder() {
    }

    public WaitBuilder(AvgMinMaxInstantStatsPct arg) {
        this._instant = arg.getInstant();
        this._avg = arg.getAvg();
        this._min = arg.getMin();
        this._max = arg.getMax();
        this._interval = arg.getInterval();
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }

    public WaitBuilder(StatIntervalState arg) {
        this._interval = arg.getInterval();
    }

    public WaitBuilder(MinMaxTime arg) {
        this._minTime = arg.getMinTime();
        this._maxTime = arg.getMaxTime();
    }

    public WaitBuilder(Wait base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Wait>>, Augmentation<Wait>>(aug);
        }
        this._avg = base.getAvg();
        this._instant = base.getInstant();
        this._interval = base.getInterval();
        this._max = base.getMax();
        this._maxTime = base.getMaxTime();
        this._min = base.getMin();
        this._minTime = base.getMinTime();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof StatIntervalState) {
            this._interval = ((StatIntervalState)arg).getInterval();
            isValidArg = true;
        }
        if (arg instanceof MinMaxTime) {
            this._minTime = ((MinMaxTime)arg).getMinTime();
            this._maxTime = ((MinMaxTime)arg).getMaxTime();
            isValidArg = true;
        }
        if (arg instanceof AvgMinMaxInstantStatsPct) {
            this._instant = ((AvgMinMaxInstantStatsPct)arg).getInstant();
            this._avg = ((AvgMinMaxInstantStatsPct)arg).getAvg();
            this._min = ((AvgMinMaxInstantStatsPct)arg).getMin();
            this._max = ((AvgMinMaxInstantStatsPct)arg).getMax();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[StatIntervalState, MinMaxTime, AvgMinMaxInstantStatsPct]");
    }

    public Percentage getAvg() {
        return this._avg;
    }

    public Percentage getInstant() {
        return this._instant;
    }

    public StatInterval getInterval() {
        return this._interval;
    }

    public Percentage getMax() {
        return this._max;
    }

    public Timeticks64 getMaxTime() {
        return this._maxTime;
    }

    public Percentage getMin() {
        return this._min;
    }

    public Timeticks64 getMinTime() {
        return this._minTime;
    }

    public <E$$ extends Augmentation<Wait>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public WaitBuilder setAvg(Percentage value) {
        this._avg = value;
        return this;
    }

    public WaitBuilder setInstant(Percentage value) {
        this._instant = value;
        return this;
    }

    public WaitBuilder setInterval(StatInterval value) {
        this._interval = value;
        return this;
    }

    public WaitBuilder setMax(Percentage value) {
        this._max = value;
        return this;
    }

    public WaitBuilder setMaxTime(Timeticks64 value) {
        this._maxTime = value;
        return this;
    }

    public WaitBuilder setMin(Percentage value) {
        this._min = value;
        return this;
    }

    public WaitBuilder setMinTime(Timeticks64 value) {
        this._minTime = value;
        return this;
    }

    public WaitBuilder addAugmentation(Augmentation<Wait> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Wait>>, Augmentation<Wait>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public WaitBuilder removeAugmentation(Class<? extends Augmentation<Wait>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Wait build() {
        return new WaitImpl(this);
    }

    private static final class WaitImpl
    extends AbstractAugmentable<Wait>
    implements Wait {
        private final Percentage _avg;
        private final Percentage _instant;
        private final StatInterval _interval;
        private final Percentage _max;
        private final Timeticks64 _maxTime;
        private final Percentage _min;
        private final Timeticks64 _minTime;
        private int hash = 0;
        private volatile boolean hashValid = false;

        WaitImpl(WaitBuilder base) {
            super(base.augmentation);
            this._avg = base.getAvg();
            this._instant = base.getInstant();
            this._interval = base.getInterval();
            this._max = base.getMax();
            this._maxTime = base.getMaxTime();
            this._min = base.getMin();
            this._minTime = base.getMinTime();
        }

        @Override
        public Percentage getAvg() {
            return this._avg;
        }

        @Override
        public Percentage getInstant() {
            return this._instant;
        }

        @Override
        public StatInterval getInterval() {
            return this._interval;
        }

        @Override
        public Percentage getMax() {
            return this._max;
        }

        @Override
        public Timeticks64 getMaxTime() {
            return this._maxTime;
        }

        @Override
        public Percentage getMin() {
            return this._min;
        }

        @Override
        public Timeticks64 getMinTime() {
            return this._minTime;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Wait.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Wait.bindingEquals(this, obj);
        }

        public String toString() {
            return Wait.bindingToString(this);
        }
    }
}

