/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingSelectorsConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingSelectorsState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SYSLOGFACILITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SyslogSeverity;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private Class<? extends SYSLOGFACILITY> _facility;
    private SyslogSeverity _severity;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }

    public StateBuilder(LoggingSelectorsConfig arg) {
        this._facility = arg.getFacility();
        this._severity = arg.getSeverity();
    }

    public StateBuilder(LoggingSelectorsState arg) {
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._facility = base.getFacility();
        this._severity = base.getSeverity();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LoggingSelectorsState) {
            isValidArg = true;
        }
        if (arg instanceof LoggingSelectorsConfig) {
            this._facility = ((LoggingSelectorsConfig)arg).getFacility();
            this._severity = ((LoggingSelectorsConfig)arg).getSeverity();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LoggingSelectorsState, LoggingSelectorsConfig]");
    }

    public Class<? extends SYSLOGFACILITY> getFacility() {
        return this._facility;
    }

    public SyslogSeverity getSeverity() {
        return this._severity;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setFacility(Class<? extends SYSLOGFACILITY> value) {
        this._facility = value;
        return this;
    }

    public StateBuilder setSeverity(SyslogSeverity value) {
        this._severity = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Class<? extends SYSLOGFACILITY> _facility;
        private final SyslogSeverity _severity;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._facility = base.getFacility();
            this._severity = base.getSeverity();
        }

        @Override
        public Class<? extends SYSLOGFACILITY> getFacility() {
            return this._facility;
        }

        @Override
        public SyslogSeverity getSeverity() {
            return this._severity;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

