/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.OpenflowConnectionsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.connections.top.Connections;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers.Controller;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers.ControllerKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers.controller.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.controllers.top.controllers.controller.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ControllerBuilder {
    private Config _config;
    private Connections _connections;
    private String _name;
    private State _state;
    private ControllerKey key;
    Map<Class<? extends Augmentation<Controller>>, Augmentation<Controller>> augmentation = Collections.emptyMap();

    public ControllerBuilder() {
    }

    public ControllerBuilder(OpenflowConnectionsTop arg) {
        this._connections = arg.getConnections();
    }

    public ControllerBuilder(Controller base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Controller>>, Augmentation<Controller>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._config = base.getConfig();
        this._connections = base.getConnections();
        this._state = base.getState();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenflowConnectionsTop) {
            this._connections = ((OpenflowConnectionsTop)arg).getConnections();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[OpenflowConnectionsTop]");
    }

    public ControllerKey key() {
        return this.key;
    }

    public Config getConfig() {
        return this._config;
    }

    public Connections getConnections() {
        return this._connections;
    }

    public String getName() {
        return this._name;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Controller>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ControllerBuilder withKey(ControllerKey key) {
        this.key = key;
        return this;
    }

    public ControllerBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public ControllerBuilder setConnections(Connections value) {
        this._connections = value;
        return this;
    }

    public ControllerBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ControllerBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ControllerBuilder addAugmentation(Augmentation<Controller> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Controller>>, Augmentation<Controller>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ControllerBuilder removeAugmentation(Class<? extends Augmentation<Controller>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Controller build() {
        return new ControllerImpl(this);
    }

    private static final class ControllerImpl
    extends AbstractAugmentable<Controller>
    implements Controller {
        private final Config _config;
        private final Connections _connections;
        private final String _name;
        private final State _state;
        private final ControllerKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ControllerImpl(ControllerBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ControllerKey(base.getName());
            this._name = this.key.getName();
            this._config = base.getConfig();
            this._connections = base.getConnections();
            this._state = base.getState();
        }

        @Override
        public ControllerKey key() {
            return this.key;
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public Connections getConnections() {
            return this._connections;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public State getState() {
            return this._state;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Controller.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Controller.bindingEquals(this, obj);
        }

        public String toString() {
            return Controller.bindingToString(this);
        }
    }
}

