/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ETHERNETSPEED;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

public interface EthernetInterfaceConfig
extends DataObject {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ethernet-interface-config");

    public Class<? extends EthernetInterfaceConfig> implementedInterface();

    public MacAddress getMacAddress();

    default public @NonNull MacAddress requireMacAddress() {
        return (MacAddress)CodeHelpers.require((Object)this.getMacAddress(), (String)"macaddress");
    }

    public Boolean getAutoNegotiate();

    default public @NonNull Boolean requireAutoNegotiate() {
        return (Boolean)CodeHelpers.require((Object)this.getAutoNegotiate(), (String)"autonegotiate");
    }

    public Boolean getStandaloneLinkTraining();

    default public @NonNull Boolean requireStandaloneLinkTraining() {
        return (Boolean)CodeHelpers.require((Object)this.getStandaloneLinkTraining(), (String)"standalonelinktraining");
    }

    public DuplexMode getDuplexMode();

    default public @NonNull DuplexMode requireDuplexMode() {
        return (DuplexMode)((Object)CodeHelpers.require((Object)((Object)this.getDuplexMode()), (String)"duplexmode"));
    }

    public Class<? extends ETHERNETSPEED> getPortSpeed();

    default public @NonNull Class<? extends ETHERNETSPEED> requirePortSpeed() {
        return (Class)CodeHelpers.require(this.getPortSpeed(), (String)"portspeed");
    }

    public Boolean getEnableFlowControl();

    default public @NonNull Boolean requireEnableFlowControl() {
        return (Boolean)CodeHelpers.require((Object)this.getEnableFlowControl(), (String)"enableflowcontrol");
    }

    public static enum DuplexMode implements Enumeration
    {
        FULL(0, "FULL"),
        HALF(1, "HALF");

        private static final Map<String, DuplexMode> NAME_MAP;
        private static final Map<Integer, DuplexMode> VALUE_MAP;
        private final String name;
        private final int value;

        private DuplexMode(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<DuplexMode> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static DuplexMode forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (DuplexMode enumItem : DuplexMode.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

