package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum VlanStackAction implements Enumeration {
    /**
     * Push a VLAN onto the VLAN stack.
     */
    PUSH(0, "PUSH"),
    
    /**
     * Pop a VLAN from the VLAN stack.
     */
    POP(1, "POP"),
    
    /**
     * Swap the VLAN at the top of the VLAN stack.
     */
    SWAP(2, "SWAP")
    ;

    private static final Map<String, VlanStackAction> NAME_MAP;
    private static final Map<Integer, VlanStackAction> VALUE_MAP;

    static {
        final Builder<String, VlanStackAction> nb = ImmutableMap.builder();
        final Builder<Integer, VlanStackAction> vb = ImmutableMap.builder();
        for (VlanStackAction enumItem : VlanStackAction.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private VlanStackAction(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding VlanStackAction item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<VlanStackAction> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding VlanStackAction item, or null if no such item exists
     */
    public static VlanStackAction forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
