package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.top.Vlan;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for VLAN data associated with a logical interface or 
 * subinterface
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-top {
 *   container vlan {
 *     container config {
 *       uses vlan-logical-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-config;
 *       uses vlan-logical-state;
 *     }
 *     uses vlan-logical-match-top;
 *     uses vlan-logical-ingress-mapping-top;
 *     uses vlan-logical-egress-mapping-top;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-top");

    @Override
    Class<? extends VlanLogicalTop> implementedInterface();
    
    /**
     * Return vlan, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for VLAN interface-specific data on subinterfaces
     *     </code>
     * </pre>
     *
     * @return {@code Vlan} vlan, or {@code null} if it is not present.
     *
     */
    Vlan getVlan();

}

