package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.match.top.Match;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration for various VLAN tag matching schemes, including Q-in-Q.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-match-top {
 *   container match {
 *     container single-tagged {
 *       container config {
 *         uses vlan-logical-single-tagged-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-single-tagged-config;
 *       }
 *     }
 *     container single-tagged-list {
 *       container config {
 *         uses vlan-logical-single-tagged-list-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-single-tagged-list-config;
 *       }
 *     }
 *     container single-tagged-range {
 *       container config {
 *         uses vlan-logical-single-tagged-range-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-single-tagged-range-config;
 *       }
 *     }
 *     container double-tagged {
 *       container config {
 *         uses vlan-logical-double-tagged-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-double-tagged-config;
 *       }
 *     }
 *     container double-tagged-inner-list {
 *       container config {
 *         uses vlan-logical-double-tagged-inner-list-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-double-tagged-inner-list-config;
 *       }
 *     }
 *     container double-tagged-outer-list {
 *       container config {
 *         uses vlan-logical-double-tagged-outer-list-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-double-tagged-outer-list-config;
 *       }
 *     }
 *     container double-tagged-inner-range {
 *       container config {
 *         uses vlan-logical-double-tagged-inner-range-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-double-tagged-inner-range-config;
 *       }
 *     }
 *     container double-tagged-outer-range {
 *       container config {
 *         uses vlan-logical-double-tagged-outer-range-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-double-tagged-outer-range-config;
 *       }
 *     }
 *     container double-tagged-inner-outer-range {
 *       container config {
 *         uses vlan-logical-double-tagged-inner-outer-range-config;
 *       }
 *       container state {
 *         config false;
 *         uses vlan-logical-double-tagged-inner-outer-range-config;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalMatchTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-match-top");

    @Override
    Class<? extends VlanLogicalMatchTop> implementedInterface();
    
    /**
     * Return match, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration for various VLAN tag matching schemes, including single-tagged
     *         802.1q packets and double-tagged 802.1ad 'Q-in-Q' packets. Typically only one of
     *         the subordinate containers should be specified. Wildcards may be matched by
     *         specifying range values of 2-4094. If implementations have a more efficient way
     *         to match Wildcards then they should recognize this pattern and translate
     *         accordingly. Implementations are expected to return errors for combinations that
     *         they do not support, or provide deviations to the same effect. For simple VLAN
     *         configurations without an 'egress-mapping' then using the 'single-tagged' and
     *         'double-tagged' VLAN matches that resolve to specific values, these specify the
     *         VLAN identifiers applied to packets on egress.
     *     </code>
     * </pre>
     *
     * @return {@code Match} match, or {@code null} if it is not present.
     *
     */
    Match getMatch();

}

