package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Specifies double-tagged packets with an inner exact and an outer range of VLAN 
 * identifiers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-double-tagged-outer-range-config {
 *   leaf inner-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf outer-low-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf outer-high-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalDoubleTaggedOuterRangeConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-double-tagged-outer-range-config");

    @Override
    Class<? extends VlanLogicalDoubleTaggedOuterRangeConfig> implementedInterface();
    
    /**
     * Return innerVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Inner VLAN identifier for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getInnerVlanId();
    
    /**
     * Return innerVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Inner VLAN identifier for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} innerVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if innerVlanId is not present
     *
     */
    default @NonNull VlanId requireInnerVlanId() {
        return CodeHelpers.require(getInnerVlanId(), "innervlanid");
    }
    
    /**
     * Return outerLowVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The low-value outer VLAN identifier for double-tagged packets. The range is
     *         matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerLowVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getOuterLowVlanId();
    
    /**
     * Return outerLowVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The low-value outer VLAN identifier for double-tagged packets. The range is
     *         matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerLowVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if outerLowVlanId is not present
     *
     */
    default @NonNull VlanId requireOuterLowVlanId() {
        return CodeHelpers.require(getOuterLowVlanId(), "outerlowvlanid");
    }
    
    /**
     * Return outerHighVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The high-value outer VLAN identifier for double-tagged packets. The range is
     *         matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerHighVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getOuterHighVlanId();
    
    /**
     * Return outerHighVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The high-value outer VLAN identifier for double-tagged packets. The range is
     *         matched inclusively.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerHighVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if outerHighVlanId is not present
     *
     */
    default @NonNull VlanId requireOuterHighVlanId() {
        return CodeHelpers.require(getOuterHighVlanId(), "outerhighvlanid");
    }

}

