package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Specifies double-tagged packets with an inner list and outer exact VLAN 
 * identifiers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-double-tagged-inner-list-config {
 *   leaf-list inner-vlan-ids {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf outer-vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalDoubleTaggedInnerListConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-double-tagged-inner-list-config");

    @Override
    Class<? extends VlanLogicalDoubleTaggedInnerListConfig> implementedInterface();
    
    /**
     * Return innerVlanIds, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Inner VLAN identifiers for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code Set<VlanId>} innerVlanIds, or {@code null} if it is not present.
     *
     */
    @Nullable Set<VlanId> getInnerVlanIds();
    
    /**
     * Return innerVlanIds, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Inner VLAN identifiers for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code Set<VlanId>} innerVlanIds, guaranteed to be non-null.
     * @throws NoSuchElementException if innerVlanIds is not present
     *
     */
    default @NonNull Set<VlanId> requireInnerVlanIds() {
        return CodeHelpers.require(getInnerVlanIds(), "innervlanids");
    }
    
    /**
     * Return outerVlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Outer VLAN identifier for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerVlanId, or {@code null} if it is not present.
     *
     */
    VlanId getOuterVlanId();
    
    /**
     * Return outerVlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Outer VLAN identifier for double-tagged packets.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} outerVlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if outerVlanId is not present
     *
     */
    default @NonNull VlanId requireOuterVlanId() {
        return CodeHelpers.require(getOuterVlanId(), "outervlanid");
    }

}

