package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.ssh.server;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerConfig.ProtocolVersion;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemTerminalCommonConfig;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Boolean _enable;
    private ProtocolVersion _protocolVersion;
    private Uint16 _rateLimit;
    private Uint16 _sessionLimit;
    private Uint16 _timeout;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Collections.emptyMap();

    public StateBuilder() {
    }
    
    
    
    public StateBuilder(SystemSshServerConfig arg) {
        this._enable = arg.getEnable();
        this._protocolVersion = arg.getProtocolVersion();
        this._timeout = arg.getTimeout();
        this._rateLimit = arg.getRateLimit();
        this._sessionLimit = arg.getSessionLimit();
    }
    public StateBuilder(SystemTerminalCommonConfig arg) {
        this._timeout = arg.getTimeout();
        this._rateLimit = arg.getRateLimit();
        this._sessionLimit = arg.getSessionLimit();
    }
    
    public StateBuilder(SystemSshServerState arg) {
    }

    public StateBuilder(State base) {
        Map<Class<? extends Augmentation<State>>, Augmentation<State>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._enable = base.getEnable();
        this._protocolVersion = base.getProtocolVersion();
        this._rateLimit = base.getRateLimit();
        this._sessionLimit = base.getSessionLimit();
        this._timeout = base.getTimeout();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SystemSshServerConfig</li>
     * <li>SystemSshServerState</li>
     * <li>SystemTerminalCommonConfig</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemSshServerConfig) {
            this._enable = ((SystemSshServerConfig)arg).getEnable();
            this._protocolVersion = ((SystemSshServerConfig)arg).getProtocolVersion();
            isValidArg = true;
        }
        if (arg instanceof SystemSshServerState) {
            isValidArg = true;
        }
        if (arg instanceof SystemTerminalCommonConfig) {
            this._timeout = ((SystemTerminalCommonConfig)arg).getTimeout();
            this._rateLimit = ((SystemTerminalCommonConfig)arg).getRateLimit();
            this._sessionLimit = ((SystemTerminalCommonConfig)arg).getSessionLimit();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemSshServerConfig, SystemSshServerState, SystemTerminalCommonConfig]");
    }

    public Boolean getEnable() {
        return _enable;
    }
    
    public ProtocolVersion getProtocolVersion() {
        return _protocolVersion;
    }
    
    public Uint16 getRateLimit() {
        return _rateLimit;
    }
    
    public Uint16 getSessionLimit() {
        return _sessionLimit;
    }
    
    public Uint16 getTimeout() {
        return _timeout;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public StateBuilder setEnable(final Boolean value) {
        this._enable = value;
        return this;
    }
    
    public StateBuilder setProtocolVersion(final ProtocolVersion value) {
        this._protocolVersion = value;
        return this;
    }
    
    public StateBuilder setRateLimit(final Uint16 value) {
        this._rateLimit = value;
        return this;
    }
    
    public StateBuilder setSessionLimit(final Uint16 value) {
        this._sessionLimit = value;
        return this;
    }
    
    public StateBuilder setTimeout(final Uint16 value) {
        this._timeout = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        Class<? extends Augmentation<State>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Boolean _enable;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerConfig.ProtocolVersion _protocolVersion;
        private final Uint16 _rateLimit;
        private final Uint16 _sessionLimit;
        private final Uint16 _timeout;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._enable = base.getEnable();
            this._protocolVersion = base.getProtocolVersion();
            this._rateLimit = base.getRateLimit();
            this._sessionLimit = base.getSessionLimit();
            this._timeout = base.getTimeout();
        }
    
        @Override
        public Boolean getEnable() {
            return _enable;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerConfig.ProtocolVersion getProtocolVersion() {
            return _protocolVersion;
        }
        
        @Override
        public Uint16 getRateLimit() {
            return _rateLimit;
        }
        
        @Override
        public Uint16 getSessionLimit() {
            return _sessionLimit;
        }
        
        @Override
        public Uint16 getTimeout() {
            return _timeout;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
