package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.terminal.common.top.TerminalServers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for common terminal service data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
 * <pre>
 * grouping system-terminal-common-top {
 *   container terminal-servers {
 *     container config {
 *       uses system-terminal-common-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-terminal-common-config;
 *       uses system-terminal-common-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemTerminalCommonTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-terminal-common-top");

    @Override
    Class<? extends SystemTerminalCommonTop> implementedInterface();
    
    /**
     * Return terminalServers, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for terminal services
     *     </code>
     * </pre>
     *
     * @return {@code TerminalServers} terminalServers, or {@code null} if it is not present.
     *
     */
    TerminalServers getTerminalServers();

}

