package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.Servers;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of NTP servers to use for system clock synchronization. If 
 * '/system/ntp/enabled' is 'true', then the system will attempt to contact and 
 * utilize the specified NTP servers.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * list server {
 *   key address;
 *   leaf address {
 *     type leafref {
 *       path ../config/address;
 *     }
 *   }
 *   container config {
 *     uses system-ntp-server-config;
 *   }
 *   container state {
 *     config false;
 *     uses system-ntp-server-config;
 *     uses system-ntp-server-state;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ServerBuilder}.
 * @see ServerBuilder
 * @see ServerKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Server
    extends
    ChildOf<Servers>,
    Augmentable<Server>,
    Identifiable<ServerKey>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("server");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.Server> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.Server.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.@NonNull Server obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAddress());
        result = prime * result + Objects.hashCode(obj.getConfig());
        result = prime * result + Objects.hashCode(obj.getState());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.@NonNull Server thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.Server other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.Server.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getAddress(), other.getAddress())) {
            return false;
        }
        if (!Objects.equals(thisObj.getConfig(), other.getConfig())) {
            return false;
        }
        if (!Objects.equals(thisObj.getState(), other.getState())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.@NonNull Server obj) {
        final var helper = MoreObjects.toStringHelper("Server");
        CodeHelpers.appendValue(helper, "address", obj.getAddress());
        CodeHelpers.appendValue(helper, "config", obj.getConfig());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    ServerKey key();
    
    /**
     * Return address, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         References the configured address or hostname of the NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code Host} address, or {@code null} if it is not present.
     *
     */
    Host getAddress();
    
    /**
     * Return address, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         References the configured address or hostname of the NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code Host} address, guaranteed to be non-null.
     * @throws NoSuchElementException if address is not present
     *
     */
    default @NonNull Host requireAddress() {
        return CodeHelpers.require(getAddress(), "address");
    }
    
    /**
     * Return config, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Configuration data for an NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code Config} config, or {@code null} if it is not present.
     *
     */
    Config getConfig();
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Operational state data for an NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();

}

