package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsServersTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsStaticTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns._static.top.HostEntries;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.Servers;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.dns.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.dns.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Dns} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Dns createDns(int fooXyzzy, int barBaz) {
 *         return new DnsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Dns, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Dns
 *
 */
@Generated("mdsal-binding-generator")
public class DnsBuilder {

    private Config _config;
    private HostEntries _hostEntries;
    private Servers _servers;
    private State _state;


    Map<Class<? extends Augmentation<Dns>>, Augmentation<Dns>> augmentation = Collections.emptyMap();

    public DnsBuilder() {
    }
    
    
    
    public DnsBuilder(SystemDnsServersTop arg) {
        this._servers = arg.getServers();
    }
    
    public DnsBuilder(SystemDnsStaticTop arg) {
        this._hostEntries = arg.getHostEntries();
    }

    public DnsBuilder(Dns base) {
        Map<Class<? extends Augmentation<Dns>>, Augmentation<Dns>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._config = base.getConfig();
        this._hostEntries = base.getHostEntries();
        this._servers = base.getServers();
        this._state = base.getState();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>SystemDnsStaticTop</li>
     * <li>SystemDnsServersTop</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemDnsStaticTop) {
            this._hostEntries = ((SystemDnsStaticTop)arg).getHostEntries();
            isValidArg = true;
        }
        if (arg instanceof SystemDnsServersTop) {
            this._servers = ((SystemDnsServersTop)arg).getServers();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemDnsStaticTop, SystemDnsServersTop]");
    }

    public Config getConfig() {
        return _config;
    }
    
    public HostEntries getHostEntries() {
        return _hostEntries;
    }
    
    public Servers getServers() {
        return _servers;
    }
    
    public State getState() {
        return _state;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Dns>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public DnsBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    public DnsBuilder setHostEntries(final HostEntries value) {
        this._hostEntries = value;
        return this;
    }
    
    public DnsBuilder setServers(final Servers value) {
        this._servers = value;
        return this;
    }
    
    public DnsBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public DnsBuilder addAugmentation(Augmentation<Dns> augmentation) {
        Class<? extends Augmentation<Dns>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public DnsBuilder removeAugmentation(Class<? extends Augmentation<Dns>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Dns} instance.
     *
     * @return A new {@link Dns} instance.
     */
    public Dns build() {
        return new DnsImpl(this);
    }

    private static final class DnsImpl
        extends AbstractAugmentable<Dns>
        implements Dns {
    
        private final Config _config;
        private final HostEntries _hostEntries;
        private final Servers _servers;
        private final State _state;
    
        DnsImpl(DnsBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._hostEntries = base.getHostEntries();
            this._servers = base.getServers();
            this._state = base.getState();
        }
    
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public HostEntries getHostEntries() {
            return _hostEntries;
        }
        
        @Override
        public Servers getServers() {
            return _servers;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Dns.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Dns.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Dns.bindingToString(this);
        }
    }
}
