package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsServersTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.servers.Server;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for DNS resolver list
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * container servers {
 *   list server {
 *     key address;
 *     ordered-by user;
 *     leaf address {
 *       type leafref {
 *         path ../config/address;
 *       }
 *     }
 *     container config {
 *       uses system-dns-servers-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-dns-servers-config;
 *       uses system-dns-servers-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ServersBuilder}.
 * @see ServersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Servers
    extends
    ChildOf<SystemDnsServersTop>,
    Augmentable<Servers>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("servers");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.Servers> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.Servers.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.@NonNull Servers obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getServer());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.@NonNull Servers thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.Servers other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.Servers.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getServer(), other.getServer())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.servers.top.@NonNull Servers obj) {
        final var helper = MoreObjects.toStringHelper("Servers");
        CodeHelpers.appendValue(helper, "server", obj.getServer());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return server, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of the DNS servers that the resolver should query. When the resolver is
     *         invoked by a calling application, it sends the query to the first name server in
     *         this list. If no response has been received within 'timeout' seconds, the
     *         resolver continues with the next server in the list. If no response is received
     *         from any server, the resolver continues with the first server again. When the
     *         resolver has traversed the list 'attempts' times without receiving any response,
     *         it gives up and returns an error to the calling application. Implementations MAY
     *         limit the number of entries in this list.
     *     </code>
     * </pre>
     *
     * @return {@code List<Server>} server, or {@code null} if it is not present.
     *
     */
    @Nullable List<Server> getServer();
    
    /**
     * Return server, or an empty list if it is not present.
     *
     * @return {@code List<Server>} server, or an empty list if it is not present.
     *
     */
    default @NonNull List<Server> nonnullServer() {
        return CodeHelpers.nonnull(getServer());
    }

}

