package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState.Index;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.cpu.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Cpu} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Cpu createCpu(int fooXyzzy, int barBaz) {
 *         return new CpuBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Cpu, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Cpu
 *
 */
@Generated("mdsal-binding-generator")
public class CpuBuilder {

    private Index _index;
    private State _state;
    private CpuKey key;


    Map<Class<? extends Augmentation<Cpu>>, Augmentation<Cpu>> augmentation = Collections.emptyMap();

    public CpuBuilder() {
    }
    
    
    

    public CpuBuilder(Cpu base) {
        Map<Class<? extends Augmentation<Cpu>>, Augmentation<Cpu>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._index = base.getIndex();
        this._state = base.getState();
    }


    public CpuKey key() {
        return key;
    }
    
    public Index getIndex() {
        return _index;
    }
    
    public State getState() {
        return _state;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Cpu>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public CpuBuilder withKey(final CpuKey key) {
        this.key = key;
        return this;
    }
    
    public CpuBuilder setIndex(final Index value) {
        this._index = value;
        return this;
    }
    
    public CpuBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public CpuBuilder addAugmentation(Augmentation<Cpu> augmentation) {
        Class<? extends Augmentation<Cpu>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public CpuBuilder removeAugmentation(Class<? extends Augmentation<Cpu>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Cpu} instance.
     *
     * @return A new {@link Cpu} instance.
     */
    public Cpu build() {
        return new CpuImpl(this);
    }

    private static final class CpuImpl
        extends AbstractAugmentable<Cpu>
        implements Cpu {
    
        private final Index _index;
        private final State _state;
        private final CpuKey key;
    
        CpuImpl(CpuBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new CpuKey(base.getIndex());
            }
            this._index = key.getIndex();
            this._state = base.getState();
        }
    
        @Override
        public CpuKey key() {
            return key;
        }
        
        @Override
        public Index getIndex() {
            return _index;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Cpu.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Cpu.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Cpu.bindingToString(this);
        }
    }
}
