package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.Ntp;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for configuration and state data for NTP
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-ntp-top {
 *   container ntp {
 *     container config {
 *       uses system-ntp-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-ntp-config;
 *       uses system-ntp-state;
 *     }
 *     uses system-ntp-auth-keys-top;
 *     uses system-ntp-server-top;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemNtpTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-ntp-top");

    @Override
    Class<? extends SystemNtpTop> implementedInterface();
    
    /**
     * Return ntp, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for NTP configuration and state
     *     </code>
     * </pre>
     *
     * @return {@code Ntp} ntp, or {@code null} if it is not present.
     *
     */
    Ntp getNtp();

}

