package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Configuration data for NTP servers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-ntp-server-config {
 *   leaf address {
 *     type oc-inet:host;
 *   }
 *   leaf port {
 *     type oc-inet:port-number;
 *     default 123;
 *   }
 *   leaf version {
 *     type uint8 {
 *       range 1..4;
 *     }
 *     default 4;
 *   }
 *   leaf association-type {
 *     type enumeration {
 *       enum SERVER {
 *       }
 *       enum PEER {
 *       }
 *       enum POOL {
 *       }
 *     }
 *     default SERVER;
 *   }
 *   leaf iburst {
 *     type boolean;
 *     default false;
 *   }
 *   leaf prefer {
 *     type boolean;
 *     default false;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemNtpServerConfig
    extends
    DataObject
{


    @Generated("mdsal-binding-generator")
    public enum AssociationType implements Enumeration {
        /**
         * Use client association mode.  This device
         * will not provide synchronization to the
         * configured NTP server.
         */
        SERVER(0, "SERVER"),
        
        /**
         * Use symmetric active association mode.
         * This device may provide synchronization
         * to the configured NTP server.
         */
        PEER(1, "PEER"),
        
        /**
         * Use client association mode with one or
         * more of the NTP servers found by DNS
         * resolution of the domain name given by
         * the 'address' leaf.  This device will not
         * provide synchronization to the servers.
         */
        POOL(2, "POOL")
        ;
    
        private static final Map<String, AssociationType> NAME_MAP;
        private static final Map<Integer, AssociationType> VALUE_MAP;
    
        static {
            final Builder<String, AssociationType> nb = ImmutableMap.builder();
            final Builder<Integer, AssociationType> vb = ImmutableMap.builder();
            for (AssociationType enumItem : AssociationType.values()) {
                vb.put(enumItem.value, enumItem);
                nb.put(enumItem.name, enumItem);
            }
    
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    
        private final String name;
        private final int value;
    
        private AssociationType(int value, String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified value.
         *
         * @param name YANG assigned name
         * @return corresponding AssociationType item, if present
         * @throws NullPointerException if name is null
         */
        public static Optional<AssociationType> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding AssociationType item, or null if no such item exists
         */
        public static AssociationType forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }
    }

    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-ntp-server-config");

    @Override
    Class<? extends SystemNtpServerConfig> implementedInterface();
    
    /**
     * Return address, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The address or hostname of the NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code Host} address, or {@code null} if it is not present.
     *
     */
    Host getAddress();
    
    /**
     * Return address, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The address or hostname of the NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code Host} address, guaranteed to be non-null.
     * @throws NoSuchElementException if address is not present
     *
     */
    default @NonNull Host requireAddress() {
        return CodeHelpers.require(getAddress(), "address");
    }
    
    /**
     * Return port, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The port number of the NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, or {@code null} if it is not present.
     *
     */
    PortNumber getPort();
    
    /**
     * Return port, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The port number of the NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code PortNumber} port, guaranteed to be non-null.
     * @throws NoSuchElementException if port is not present
     *
     */
    default @NonNull PortNumber requirePort() {
        return CodeHelpers.require(getPort(), "port");
    }
    
    /**
     * Return version, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Version number to put in outgoing NTP packets
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} version, or {@code null} if it is not present.
     *
     */
    Uint8 getVersion();
    
    /**
     * Return version, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Version number to put in outgoing NTP packets
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} version, guaranteed to be non-null.
     * @throws NoSuchElementException if version is not present
     *
     */
    default @NonNull Uint8 requireVersion() {
        return CodeHelpers.require(getVersion(), "version");
    }
    
    /**
     * Return associationType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The desired association type for this NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code AssociationType} associationType, or {@code null} if it is not present.
     *
     */
    AssociationType getAssociationType();
    
    /**
     * Return associationType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The desired association type for this NTP server.
     *     </code>
     * </pre>
     *
     * @return {@code AssociationType} associationType, guaranteed to be non-null.
     * @throws NoSuchElementException if associationType is not present
     *
     */
    default @NonNull AssociationType requireAssociationType() {
        return CodeHelpers.require(getAssociationType(), "associationtype");
    }
    
    /**
     * Return iburst, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indicates whether this server should enable burst synchronization or not.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} iburst, or {@code null} if it is not present.
     *
     */
    Boolean getIburst();
    
    /**
     * Return iburst, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Indicates whether this server should enable burst synchronization or not.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} iburst, guaranteed to be non-null.
     * @throws NoSuchElementException if iburst is not present
     *
     */
    default @NonNull Boolean requireIburst() {
        return CodeHelpers.require(getIburst(), "iburst");
    }
    
    /**
     * Return prefer, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Indicates whether this server should be preferred or not.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} prefer, or {@code null} if it is not present.
     *
     */
    Boolean getPrefer();
    
    /**
     * Return prefer, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Indicates whether this server should be preferred or not.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} prefer, guaranteed to be non-null.
     * @throws NoSuchElementException if prefer is not present
     *
     */
    default @NonNull Boolean requirePrefer() {
        return CodeHelpers.require(getPrefer(), "prefer");
    }

}

