package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.NtpKeys;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for NTP auth key data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-ntp-auth-keys-top {
 *   container ntp-keys {
 *     list ntp-key {
 *       key key-id;
 *       leaf key-id {
 *         type leafref {
 *           path ../config/key-id;
 *         }
 *       }
 *       container config {
 *         uses system-ntp-auth-keys-config;
 *       }
 *       container state {
 *         config false;
 *         uses system-ntp-auth-keys-config;
 *         uses system-ntp-auth-keys-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemNtpAuthKeysTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-ntp-auth-keys-top");

    @Override
    Class<? extends SystemNtpAuthKeysTop> implementedInterface();
    
    /**
     * Return ntpKeys, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for list of NTP authentication keys
     *     </code>
     * </pre>
     *
     * @return {@code NtpKeys} ntpKeys, or {@code null} if it is not present.
     *
     */
    NtpKeys getNtpKeys();

}

