package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Configuration data 
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-ntp-auth-keys-config {
 *   leaf key-id {
 *     type uint16;
 *   }
 *   leaf key-type {
 *     type identityref {
 *       base NTP_AUTH_TYPE;
 *     }
 *   }
 *   leaf key-value {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemNtpAuthKeysConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-ntp-auth-keys-config");

    @Override
    Class<? extends SystemNtpAuthKeysConfig> implementedInterface();
    
    /**
     * Return keyId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Integer identifier used by the client and server to designate a secret key. The
     *         client and server must use the same key id.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} keyId, or {@code null} if it is not present.
     *
     */
    Uint16 getKeyId();
    
    /**
     * Return keyId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Integer identifier used by the client and server to designate a secret key. The
     *         client and server must use the same key id.
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} keyId, guaranteed to be non-null.
     * @throws NoSuchElementException if keyId is not present
     *
     */
    default @NonNull Uint16 requireKeyId() {
        return CodeHelpers.require(getKeyId(), "keyid");
    }
    
    /**
     * Return keyType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Encryption type used for the NTP authentication key
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends NTPAUTHTYPE>} keyType, or {@code null} if it is not present.
     *
     */
    Class<? extends NTPAUTHTYPE> getKeyType();
    
    /**
     * Return keyType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Encryption type used for the NTP authentication key
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends NTPAUTHTYPE>} keyType, guaranteed to be non-null.
     * @throws NoSuchElementException if keyType is not present
     *
     */
    default @NonNull Class<? extends NTPAUTHTYPE> requireKeyType() {
        return CodeHelpers.require(getKeyType(), "keytype");
    }
    
    /**
     * Return keyValue, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         NTP authentication key value
     *     </code>
     * </pre>
     *
     * @return {@code String} keyValue, or {@code null} if it is not present.
     *
     */
    String getKeyValue();
    
    /**
     * Return keyValue, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         NTP authentication key value
     *     </code>
     * </pre>
     *
     * @return {@code String} keyValue, guaranteed to be non-null.
     * @throws NoSuchElementException if keyValue is not present
     *
     */
    default @NonNull String requireKeyValue() {
        return CodeHelpers.require(getKeyValue(), "keyvalue");
    }

}

