package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.DomainName;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * system-wide configuration parameters
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-global-config {
 *   leaf hostname {
 *     type oc-inet:domain-name;
 *   }
 *   leaf domain-name {
 *     type oc-inet:domain-name;
 *   }
 *   leaf login-banner {
 *     type string;
 *   }
 *   leaf motd-banner {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemGlobalConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-global-config");

    @Override
    Class<? extends SystemGlobalConfig> implementedInterface();
    
    /**
     * Return hostname, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The hostname of the device -- should be a single domain label, without the
     *         domain.
     *     </code>
     * </pre>
     *
     * @return {@code DomainName} hostname, or {@code null} if it is not present.
     *
     */
    DomainName getHostname();
    
    /**
     * Return hostname, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The hostname of the device -- should be a single domain label, without the
     *         domain.
     *     </code>
     * </pre>
     *
     * @return {@code DomainName} hostname, guaranteed to be non-null.
     * @throws NoSuchElementException if hostname is not present
     *
     */
    default @NonNull DomainName requireHostname() {
        return CodeHelpers.require(getHostname(), "hostname");
    }
    
    /**
     * Return domainName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Specifies the domain name used to form fully qualified name for unqualified
     *         hostnames.
     *     </code>
     * </pre>
     *
     * @return {@code DomainName} domainName, or {@code null} if it is not present.
     *
     */
    DomainName getDomainName();
    
    /**
     * Return domainName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Specifies the domain name used to form fully qualified name for unqualified
     *         hostnames.
     *     </code>
     * </pre>
     *
     * @return {@code DomainName} domainName, guaranteed to be non-null.
     * @throws NoSuchElementException if domainName is not present
     *
     */
    default @NonNull DomainName requireDomainName() {
        return CodeHelpers.require(getDomainName(), "domainname");
    }
    
    /**
     * Return loginBanner, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The console login message displayed before the login prompt, i.e., before a user
     *         logs into the system.
     *     </code>
     * </pre>
     *
     * @return {@code String} loginBanner, or {@code null} if it is not present.
     *
     */
    String getLoginBanner();
    
    /**
     * Return loginBanner, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The console login message displayed before the login prompt, i.e., before a user
     *         logs into the system.
     *     </code>
     * </pre>
     *
     * @return {@code String} loginBanner, guaranteed to be non-null.
     * @throws NoSuchElementException if loginBanner is not present
     *
     */
    default @NonNull String requireLoginBanner() {
        return CodeHelpers.require(getLoginBanner(), "loginbanner");
    }
    
    /**
     * Return motdBanner, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The console message displayed after a user logs into the system. They system may
     *         append additional standard information such as the current system date and time,
     *         uptime, last login timestamp, etc.
     *     </code>
     * </pre>
     *
     * @return {@code String} motdBanner, or {@code null} if it is not present.
     *
     */
    String getMotdBanner();
    
    /**
     * Return motdBanner, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The console message displayed after a user logs into the system. They system may
     *         append additional standard information such as the current system date and time,
     *         uptime, last login timestamp, etc.
     *     </code>
     * </pre>
     *
     * @return {@code String} motdBanner, guaranteed to be non-null.
     * @throws NoSuchElementException if motdBanner is not present
     *
     */
    default @NonNull String requireMotdBanner() {
        return CodeHelpers.require(getMotdBanner(), "motdbanner");
    }

}

