package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.DomainName;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * DNS / resolver related configuration data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-dns-config {
 *   leaf-list search {
 *     type oc-inet:domain-name;
 *     ordered-by user;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemDnsConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-dns-config");

    @Override
    Class<? extends SystemDnsConfig> implementedInterface();
    
    /**
     * Return search, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An ordered list of domains to search when resolving a host name.
     *     </code>
     * </pre>
     *
     * @return {@code List<DomainName>} search, or {@code null} if it is not present.
     *
     */
    @Nullable List<DomainName> getSearch();
    
    /**
     * Return search, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An ordered list of domains to search when resolving a host name.
     *     </code>
     * </pre>
     *
     * @return {@code List<DomainName>} search, guaranteed to be non-null.
     * @throws NoSuchElementException if search is not present
     *
     */
    default @NonNull List<DomainName> requireSearch() {
        return CodeHelpers.require(getSearch(), "search");
    }

}

