package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.clock.top.Clock;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for system-wide clock configuration
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * grouping system-clock-top {
 *   container clock {
 *     container config {
 *       uses system-clock-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-clock-config;
 *       uses system-clock-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemClockTop
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-clock-top");

    @Override
    Class<? extends SystemClockTop> implementedInterface();
    
    /**
     * Return clock, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for clock configuration data
     *     </code>
     * </pre>
     *
     * @return {@code Clock} clock, or {@code null} if it is not present.
     *
     */
    Clock getClock();

}

