package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Class that builds {@link Process} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Process createProcess(int fooXyzzy, int barBaz) {
 *         return new ProcessBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Process, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Process
 *
 */
@Generated("mdsal-binding-generator")
public class ProcessBuilder {

    private Uint64 _pid;
    private State _state;
    private ProcessKey key;


    Map<Class<? extends Augmentation<Process>>, Augmentation<Process>> augmentation = Collections.emptyMap();

    public ProcessBuilder() {
    }
    
    
    

    public ProcessBuilder(Process base) {
        Map<Class<? extends Augmentation<Process>>, Augmentation<Process>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._pid = base.getPid();
        this._state = base.getState();
    }


    public ProcessKey key() {
        return key;
    }
    
    public Uint64 getPid() {
        return _pid;
    }
    
    public State getState() {
        return _state;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Process>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ProcessBuilder withKey(final ProcessKey key) {
        this.key = key;
        return this;
    }
    
    public ProcessBuilder setPid(final Uint64 value) {
        this._pid = value;
        return this;
    }
    
    public ProcessBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ProcessBuilder addAugmentation(Augmentation<Process> augmentation) {
        Class<? extends Augmentation<Process>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ProcessBuilder removeAugmentation(Class<? extends Augmentation<Process>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Process} instance.
     *
     * @return A new {@link Process} instance.
     */
    public Process build() {
        return new ProcessImpl(this);
    }

    private static final class ProcessImpl
        extends AbstractAugmentable<Process>
        implements Process {
    
        private final Uint64 _pid;
        private final State _state;
        private final ProcessKey key;
    
        ProcessImpl(ProcessBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ProcessKey(base.getPid());
            }
            this._pid = key.getPid();
            this._state = base.getState();
        }
    
        @Override
        public ProcessKey key() {
            return key;
        }
        
        @Override
        public Uint64 getPid() {
            return _pid;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Process.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Process.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Process.bindingToString(this);
        }
    }
}
