package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.RemoteServer;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.remote.top.remote.servers.RemoteServerKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link RemoteServers} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     RemoteServers createRemoteServers(int fooXyzzy, int barBaz) {
 *         return new RemoteServersBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of RemoteServers, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see RemoteServers
 *
 */
@Generated("mdsal-binding-generator")
public class RemoteServersBuilder {

    private Map<RemoteServerKey, RemoteServer> _remoteServer;


    Map<Class<? extends Augmentation<RemoteServers>>, Augmentation<RemoteServers>> augmentation = Collections.emptyMap();

    public RemoteServersBuilder() {
    }
    
    

    public RemoteServersBuilder(RemoteServers base) {
        Map<Class<? extends Augmentation<RemoteServers>>, Augmentation<RemoteServers>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._remoteServer = base.getRemoteServer();
    }


    public Map<RemoteServerKey, RemoteServer> getRemoteServer() {
        return _remoteServer;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<RemoteServers>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RemoteServersBuilder setRemoteServer(final Map<RemoteServerKey, RemoteServer> values) {
        this._remoteServer = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public RemoteServersBuilder addAugmentation(Augmentation<RemoteServers> augmentation) {
        Class<? extends Augmentation<RemoteServers>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public RemoteServersBuilder removeAugmentation(Class<? extends Augmentation<RemoteServers>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link RemoteServers} instance.
     *
     * @return A new {@link RemoteServers} instance.
     */
    public RemoteServers build() {
        return new RemoteServersImpl(this);
    }

    private static final class RemoteServersImpl
        extends AbstractAugmentable<RemoteServers>
        implements RemoteServers {
    
        private final Map<RemoteServerKey, RemoteServer> _remoteServer;
    
        RemoteServersImpl(RemoteServersBuilder base) {
            super(base.augmentation);
            this._remoteServer = CodeHelpers.emptyToNull(base.getRemoteServer());
        }
    
        @Override
        public Map<RemoteServerKey, RemoteServer> getRemoteServer() {
            return _remoteServer;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = RemoteServers.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return RemoteServers.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return RemoteServers.bindingToString(this);
        }
    }
}
