package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for logging selectors
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-logging</b>
 * <pre>
 * grouping logging-selectors-config {
 *   leaf facility {
 *     type identityref {
 *       base SYSLOG_FACILITY;
 *     }
 *   }
 *   leaf severity {
 *     type syslog-severity;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface LoggingSelectorsConfig
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("logging-selectors-config");

    @Override
    Class<? extends LoggingSelectorsConfig> implementedInterface();
    
    /**
     * Return facility, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Specifies the facility, or class of messages to log
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends SYSLOGFACILITY>} facility, or {@code null} if it is not present.
     *
     */
    Class<? extends SYSLOGFACILITY> getFacility();
    
    /**
     * Return facility, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Specifies the facility, or class of messages to log
     *     </code>
     * </pre>
     *
     * @return {@code Class<? extends SYSLOGFACILITY>} facility, guaranteed to be non-null.
     * @throws NoSuchElementException if facility is not present
     *
     */
    default @NonNull Class<? extends SYSLOGFACILITY> requireFacility() {
        return CodeHelpers.require(getFacility(), "facility");
    }
    
    /**
     * Return severity, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Specifies that only messages of the given severity (or greater severity) for the
     *         corresonding facility are logged
     *     </code>
     * </pre>
     *
     * @return {@code SyslogSeverity} severity, or {@code null} if it is not present.
     *
     */
    SyslogSeverity getSeverity();
    
    /**
     * Return severity, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Specifies that only messages of the given severity (or greater severity) for the
     *         corresonding facility are logged
     *     </code>
     * </pre>
     *
     * @return {@code SyslogSeverity} severity, guaranteed to be non-null.
     * @throws NoSuchElementException if severity is not present
     *
     */
    default @NonNull SyslogSeverity requireSeverity() {
        return CodeHelpers.require(getSeverity(), "severity");
    }

}

