package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.types.rev210118;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.Enumeration;

@Generated("mdsal-binding-generator")
public enum ComponentPowerType implements Enumeration {
    /**
     * Enable power on the component
     */
    POWERENABLED(0, "POWER_ENABLED"),
    
    /**
     * Disable power on the component
     */
    POWERDISABLED(1, "POWER_DISABLED")
    ;

    private static final Map<String, ComponentPowerType> NAME_MAP;
    private static final Map<Integer, ComponentPowerType> VALUE_MAP;

    static {
        final Builder<String, ComponentPowerType> nb = ImmutableMap.builder();
        final Builder<Integer, ComponentPowerType> vb = ImmutableMap.builder();
        for (ComponentPowerType enumItem : ComponentPowerType.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }

        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }

    private final String name;
    private final int value;

    private ComponentPowerType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified value.
     *
     * @param name YANG assigned name
     * @return corresponding ComponentPowerType item, if present
     * @throws NullPointerException if name is null
     */
    public static Optional<ComponentPowerType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding ComponentPowerType item, or null if no such item exists
     */
    public static ComponentPowerType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }
}
